/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.inventory;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import tfar.dankstorage.ModTags;
import tfar.dankstorage.utils.DankStats;

public class DankHandler
extends ItemStackHandler {
    public int[] lockedSlots;
    protected DankStats stats;

    public DankHandler(DankStats stats) {
        super(stats.slots);
        this.lockedSlots = new int[stats.slots];
        this.stats = stats;
    }

    public void setStats(DankStats stats) {
        this.stats = stats;
        this.setSize(stats.slots);
    }

    public void setSize(int size) {
        NonNullList newStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        int[] newLocked = new int[size];
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (i >= size) continue;
            newStacks.set(i, (Object)stack);
            newLocked[i] = this.lockedSlots[i];
        }
        this.stacks = newStacks;
        this.lockedSlots = newLocked;
    }

    public boolean isEmpty() {
        return IntStream.range(0, this.getSlots()).allMatch(i -> this.getStackInSlot(i).func_190926_b());
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.getSlots()).mapToObj(this::getStackInSlot).allMatch(stack -> stack.func_190926_b() || stack.func_77973_b().func_206844_a(ModTags.BLACKLISTED_USAGE));
    }

    public void onContentsChanged(int slot) {
    }

    public int getSlotLimit(int slot) {
        return this.stats.stacklimit;
    }

    public int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.stats.stacklimit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return !stack.func_77973_b().func_206844_a(ModTags.BLACKLISTED_STORAGE);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        boolean isLocked = this.isLocked(slot);
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, this.stats.stacklimit);
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                if (isLocked) {
                    this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)1));
                } else {
                    this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                }
                this.onContentsChanged(slot);
            }
            if (isLocked) {
                if (existing.func_190916_E() == 1) {
                    return ItemStack.field_190927_a;
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - 1));
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public NonNullList<ItemStack> getContents() {
        return this.stacks;
    }

    public void lockSlot(int slot) {
        this.lockedSlots[slot] = 1 - this.lockedSlots[slot];
    }

    public boolean isLocked(int slot) {
        return this.lockedSlots[slot] == 1;
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.getContents().get(i)).func_190926_b()) continue;
            int realCount = Math.min(this.stats.stacklimit, ((ItemStack)this.getContents().get(i)).func_190916_E());
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.getContents().get(i)).func_77955_b(itemTag);
            itemTag.func_74768_a("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        if (this.lockedSlots.length > 0) {
            nbt.func_74783_a("LockedSlots", this.lockedSlots);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.lockedSlots = nbt.func_74759_k("LockedSlots");
        if (this.lockedSlots.length < this.stats.slots) {
            this.lockedSlots = new int[this.stats.slots];
        }
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            ItemStack stack;
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            if (itemTags.func_150297_b("StackList", 9)) {
                stack = ItemStack.field_190927_a;
                ListNBT stackTagList = itemTags.func_150295_c("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundNBT itemTag = stackTagList.func_150305_b(j);
                    ItemStack temp = ItemStack.func_199557_a((CompoundNBT)itemTag);
                    if (temp.func_190926_b()) continue;
                    if (stack.func_190926_b()) {
                        stack = temp;
                        continue;
                    }
                    stack.func_190917_f(temp.func_190916_E());
                }
                if (stack.func_190926_b()) continue;
                int count = stack.func_190916_E();
                count = Math.min(count, this.getStackLimit(slot, stack));
                stack.func_190920_e(count);
                this.stacks.set(slot, (Object)stack);
                continue;
            }
            stack = ItemStack.func_199557_a((CompoundNBT)itemTags);
            if (itemTags.func_150297_b("ExtendedCount", 3)) {
                stack.func_190920_e(itemTags.func_74762_e("ExtendedCount"));
            }
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(slot);
    }

    public boolean canPlayerUse(PlayerEntity player) {
        return false;
    }

    public int calcRedstone() {
        int numStacks = 0;
        float f = 0.0f;
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            f += (float)stack.func_190916_E() / (float)this.getStackLimit(slot, stack);
            ++numStacks;
        }
        return MathHelper.func_76141_d((float)((f /= (float)this.getSlots()) * 14.0f)) + (numStacks > 0 ? 1 : 0);
    }

    public void onOpen(PlayerEntity player) {
    }

    public void onClose(PlayerEntity player) {
    }
}

