/*
 * Decompiled with CFR 0.152.
 */
package tfar.dankstorage.container;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.fml.network.NetworkDirection;
import tfar.dankstorage.inventory.CappedSlot;
import tfar.dankstorage.inventory.DankHandler;
import tfar.dankstorage.inventory.DankSlot;
import tfar.dankstorage.inventory.PortableDankHandler;
import tfar.dankstorage.network.DankPacketHandler;
import tfar.dankstorage.network.S2CSyncExtendedSlotContents;
import tfar.dankstorage.utils.Utils;

public abstract class AbstractDankContainer
extends Container {
    public final int rows;
    public final IIntArray propertyDelegate;
    public final DankHandler dankHandler;
    public final PlayerInventory playerInventory;

    public AbstractDankContainer(ContainerType<?> type, int id, PlayerInventory playerInv, DankHandler dankHandler, IIntArray propertyDelegate) {
        super(type, id);
        this.rows = dankHandler.getSlots() / 9;
        this.dankHandler = dankHandler;
        this.propertyDelegate = propertyDelegate;
        this.playerInventory = playerInv;
        this.func_216961_a(propertyDelegate);
        dankHandler.onOpen(playerInv.field_70458_d);
    }

    public void addOwnSlots(boolean portable) {
        int slotIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 18;
                if (portable) {
                    this.func_75146_a((Slot)new DankSlot(this.dankHandler, slotIndex, x, y){

                        @Override
                        public void func_75218_e() {
                            super.func_75218_e();
                            if (!AbstractDankContainer.this.playerInventory.field_70458_d.field_70170_p.field_72995_K) {
                                AbstractDankContainer.this.propertyDelegate.func_221477_a(AbstractDankContainer.this.dankHandler.getSlots(), Utils.getNbtSize(((PortableDankHandler)AbstractDankContainer.this.dankHandler).bag));
                            }
                        }
                    });
                } else {
                    this.func_75146_a((Slot)new DankSlot(this.dankHandler, slotIndex, x, y));
                }
                ++slotIndex;
            }
        }
    }

    protected void addPlayerSlots(PlayerInventory playerinventory) {
        int row;
        int yStart = 32 + 18 * this.rows;
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + yStart;
                this.func_75146_a(new CappedSlot((IInventory)playerinventory, col + row * 9 + 9, x, y));
            }
        }
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = yStart + 58;
            this.func_75146_a(new CappedSlot((IInventory)playerinventory, row, x, y));
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemstack = slotStack.func_77946_l();
            if (index < this.rows * 9 ? !this.func_75135_a(slotStack, this.rows * 9, this.field_75151_b.size(), true) : !this.func_75135_a(slotStack, 0, this.rows * 9, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    @Nonnull
    public ItemStack func_241440_b_(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        boolean locked = slotId >= 0 && slotId < this.rows * 9 && this.propertyDelegate.func_221476_a(slotId) == 1;
        ItemStack returnStack = ItemStack.field_190927_a;
        PlayerInventory PlayerInventory2 = player.field_71071_by;
        if (clickTypeIn == ClickType.QUICK_CRAFT) {
            int j1 = this.field_94536_g;
            this.field_94536_g = AbstractDankContainer.func_94532_c((int)dragType);
            if ((j1 != 1 || this.field_94536_g != 2) && j1 != this.field_94536_g) {
                this.func_94533_d();
            } else if (PlayerInventory2.func_70445_o().func_190926_b()) {
                this.func_94533_d();
            } else if (this.field_94536_g == 0) {
                this.field_94535_f = AbstractDankContainer.func_94529_b((int)dragType);
                if (AbstractDankContainer.func_180610_a((int)this.field_94535_f, (PlayerEntity)player)) {
                    this.field_94536_g = 1;
                    this.field_94537_h.clear();
                } else {
                    this.func_94533_d();
                }
            } else if (this.field_94536_g == 1) {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                ItemStack mouseStack = PlayerInventory2.func_70445_o();
                if (slot != null && AbstractDankContainer.canAddItemToSlot(slot, mouseStack, true) && slot.func_75214_a(mouseStack) && (this.field_94535_f == 2 || mouseStack.func_190916_E() > this.field_94537_h.size()) && this.func_94531_b(slot)) {
                    this.field_94537_h.add(slot);
                }
            } else if (this.field_94536_g == 2) {
                if (!this.field_94537_h.isEmpty()) {
                    ItemStack mouseStackCopy = PlayerInventory2.func_70445_o().func_77946_l();
                    int k1 = PlayerInventory2.func_70445_o().func_190916_E();
                    for (Slot dragSlot : this.field_94537_h) {
                        ItemStack mouseStack = PlayerInventory2.func_70445_o();
                        if (dragSlot == null || !AbstractDankContainer.canAddItemToSlot(dragSlot, mouseStack, true) || !dragSlot.func_75214_a(mouseStack) || this.field_94535_f != 2 && mouseStack.func_190916_E() < this.field_94537_h.size() || !this.func_94531_b(dragSlot)) continue;
                        ItemStack itemstack14 = mouseStackCopy.func_77946_l();
                        int j3 = dragSlot.func_75216_d() ? dragSlot.func_75211_c().func_190916_E() : 0;
                        AbstractDankContainer.func_94525_a((Set)this.field_94537_h, (int)this.field_94535_f, (ItemStack)itemstack14, (int)j3);
                        int k3 = dragSlot.func_178170_b(itemstack14);
                        if (itemstack14.func_190916_E() > k3) {
                            itemstack14.func_190920_e(k3);
                        }
                        k1 -= itemstack14.func_190916_E() - j3;
                        dragSlot.func_75215_d(itemstack14);
                    }
                    mouseStackCopy.func_190920_e(k1);
                    PlayerInventory2.func_70437_b(mouseStackCopy);
                }
                this.func_94533_d();
            } else {
                this.func_94533_d();
            }
        } else if (this.field_94536_g != 0) {
            this.func_94533_d();
        } else if (!(clickTypeIn != ClickType.PICKUP && clickTypeIn != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1)) {
            if (slotId == -999) {
                if (!PlayerInventory2.func_70445_o().func_190926_b()) {
                    if (dragType == 0) {
                        player.func_71019_a(PlayerInventory2.func_70445_o(), true);
                        PlayerInventory2.func_70437_b(ItemStack.field_190927_a);
                    }
                    if (dragType == 1) {
                        player.func_71019_a(PlayerInventory2.func_70445_o().func_77979_a(1), true);
                    }
                }
            } else if (clickTypeIn == ClickType.QUICK_MOVE) {
                if (slotId < 0) {
                    return ItemStack.field_190927_a;
                }
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                if (slot == null || !slot.func_82869_a(player)) {
                    return ItemStack.field_190927_a;
                }
                ItemStack itemstack7 = this.func_82846_b(player, slotId);
                while (!itemstack7.func_190926_b() && ItemStack.func_179545_c((ItemStack)slot.func_75211_c(), (ItemStack)itemstack7)) {
                    returnStack = itemstack7.func_77946_l();
                    itemstack7 = this.func_82846_b(player, slotId);
                }
            } else {
                if (slotId < 0) {
                    return ItemStack.field_190927_a;
                }
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                if (slot != null) {
                    ItemStack slotStack = slot.func_75211_c();
                    ItemStack mouseStack = PlayerInventory2.func_70445_o();
                    if (!slotStack.func_190926_b()) {
                        returnStack = slotStack.func_77946_l();
                    }
                    if (slotStack.func_190926_b()) {
                        if (!mouseStack.func_190926_b() && slot.func_75214_a(mouseStack)) {
                            int i3;
                            int n = i3 = dragType == 0 ? mouseStack.func_190916_E() : 1;
                            if (i3 > slot.func_178170_b(mouseStack)) {
                                i3 = slot.func_178170_b(mouseStack);
                            }
                            slot.func_75215_d(mouseStack.func_77979_a(i3));
                        }
                    } else if (slot.func_82869_a(player)) {
                        int j2;
                        if (mouseStack.func_190926_b()) {
                            if (slotStack.func_190926_b()) {
                                slot.func_75215_d(ItemStack.field_190927_a);
                                PlayerInventory2.func_70437_b(ItemStack.field_190927_a);
                            } else {
                                int toMove = slot instanceof DankSlot ? (slotStack.func_77976_d() < slotStack.func_190916_E() ? (dragType == 0 ? slotStack.func_77976_d() : (slotStack.func_77976_d() + 1) / 2) : (dragType == 0 ? slotStack.func_190916_E() : (slotStack.func_190916_E() + 1) / 2)) : (dragType == 0 ? slotStack.func_190916_E() : (slotStack.func_190916_E() + 1) / 2);
                                PlayerInventory2.func_70437_b(slot.func_75209_a(toMove));
                                if (slotStack.func_190926_b()) {
                                    slot.func_75215_d(ItemStack.field_190927_a);
                                }
                                slot.func_190901_a(player, PlayerInventory2.func_70445_o());
                            }
                        } else if (slot.func_75214_a(mouseStack)) {
                            if (slotStack.func_77973_b() == mouseStack.func_77973_b() && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseStack)) {
                                int k2;
                                int n = k2 = dragType == 0 ? mouseStack.func_190916_E() : 1;
                                if (k2 > slot.func_178170_b(mouseStack) - slotStack.func_190916_E()) {
                                    k2 = slot.func_178170_b(mouseStack) - slotStack.func_190916_E();
                                }
                                mouseStack.func_190918_g(k2);
                                slotStack.func_190917_f(k2);
                            } else if (mouseStack.func_190916_E() <= slot.func_178170_b(mouseStack) && slotStack.func_190916_E() <= slotStack.func_77976_d()) {
                                slot.func_75215_d(mouseStack);
                                PlayerInventory2.func_70437_b(slotStack);
                            }
                        } else if (slotStack.func_77973_b() == mouseStack.func_77973_b() && mouseStack.func_77976_d() > 1 && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)mouseStack) && !slotStack.func_190926_b() && (j2 = slotStack.func_190916_E()) + mouseStack.func_190916_E() <= mouseStack.func_77976_d()) {
                            mouseStack.func_190917_f(j2);
                            slotStack = slot.func_75209_a(j2);
                            if (slotStack.func_190926_b()) {
                                slot.func_75215_d(ItemStack.field_190927_a);
                            }
                            slot.func_190901_a(player, PlayerInventory2.func_70445_o());
                        }
                    }
                    slot.func_75218_e();
                }
            }
        } else if (clickTypeIn != ClickType.SWAP || dragType < 0 || dragType >= 9) {
            if (clickTypeIn == ClickType.CLONE && player.field_71075_bZ.field_75098_d && PlayerInventory2.func_70445_o().func_190926_b() && slotId >= 0) {
                Slot slot3 = (Slot)this.field_75151_b.get(slotId);
                if (slot3 != null && slot3.func_75216_d()) {
                    ItemStack itemstack5 = slot3.func_75211_c().func_77946_l();
                    itemstack5.func_190920_e(itemstack5.func_77976_d());
                    PlayerInventory2.func_70437_b(itemstack5);
                }
            } else if (clickTypeIn == ClickType.THROW && PlayerInventory2.func_70445_o().func_190926_b() && slotId >= 0) {
                Slot slot = (Slot)this.field_75151_b.get(slotId);
                if (slot != null && slot.func_75216_d() && slot.func_82869_a(player)) {
                    ItemStack itemstack4 = slot.func_75209_a(dragType == 0 ? 1 : slot.func_75211_c().func_190916_E());
                    slot.func_190901_a(player, itemstack4);
                    player.func_71019_a(itemstack4, true);
                }
            } else if (clickTypeIn != ClickType.PICKUP_ALL || slotId >= 0) {
                // empty if block
            }
        }
        if (returnStack.func_190916_E() > 64) {
            returnStack = returnStack.func_77946_l();
            returnStack.func_190920_e(64);
        }
        return returnStack;
    }

    public final boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return this.dankHandler.canPlayerUse(playerIn);
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        while (!stack.func_190926_b() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
            Slot slot = (Slot)this.field_75151_b.get(i);
            ItemStack slotStack = slot.func_75211_c();
            if (!slotStack.func_190926_b() && slotStack.func_77973_b() == stack.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotStack)) {
                int maxSize;
                int j = slotStack.func_190916_E() + stack.func_190916_E();
                if (j <= (maxSize = slot.func_178170_b(slotStack))) {
                    stack.func_190920_e(0);
                    slotStack.func_190920_e(j);
                    slot.func_75218_e();
                    flag = true;
                } else if (slotStack.func_190916_E() < maxSize) {
                    stack.func_190918_g(maxSize - slotStack.func_190916_E());
                    slotStack.func_190920_e(maxSize);
                    slot.func_75218_e();
                    flag = true;
                }
            }
            i += reverseDirection ? -1 : 1;
        }
        if (!stack.func_190926_b()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot slot1 = (Slot)this.field_75151_b.get(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_178170_b(stack)) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_178170_b(stack)));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return flag;
    }

    public static boolean canAddItemToSlot(@Nullable Slot slot, @Nonnull ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.func_75216_d();
        if (slot != null) {
            ItemStack slotStack = slot.func_75211_c();
            if (!flag && stack.func_77969_a(slotStack) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)stack)) {
                return slotStack.func_190916_E() + (stackSizeMatters ? 0 : stack.func_190916_E()) <= slot.func_178170_b(slotStack);
            }
        }
        return flag;
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
            if (!ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) {
                itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
                this.field_75153_a.set(i, (Object)itemstack1);
                for (IContainerListener listener : this.field_75149_d) {
                    if (!(listener instanceof ServerPlayerEntity)) continue;
                    ServerPlayerEntity player = (ServerPlayerEntity)listener;
                    this.syncSlot(player, i, itemstack1);
                }
            }
            for (int j = 0; j < this.field_216964_d.size(); ++j) {
                IntReferenceHolder intreferenceholder = (IntReferenceHolder)this.field_216964_d.get(j);
                if (!intreferenceholder.func_221496_c()) continue;
                for (IContainerListener icontainerlistener1 : this.field_75149_d) {
                    icontainerlistener1.func_71112_a((Container)this, j, intreferenceholder.func_221495_b());
                }
            }
        }
    }

    public void func_75132_a(IContainerListener listener) {
        if (this.field_75149_d.contains(listener)) {
            throw new IllegalArgumentException("Listener already listening");
        }
        this.field_75149_d.add(listener);
        if (listener instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)listener;
            this.syncInventory(player);
        }
        this.func_75142_b();
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.dankHandler.onClose(playerIn);
    }

    public void syncInventory(ServerPlayerEntity player) {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack stack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            DankPacketHandler.INSTANCE.sendTo((Object)new S2CSyncExtendedSlotContents(this.field_75152_c, i, stack), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
        }
        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, player.field_71071_by.func_70445_o()));
    }

    public void syncSlot(ServerPlayerEntity player, int slot, ItemStack stack) {
        DankPacketHandler.INSTANCE.sendTo((Object)new S2CSyncExtendedSlotContents(this.field_75152_c, slot, stack), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }
}

