/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public class NbtPathExpressionParseHandlerListElement
implements INbtPathExpressionParseHandler {
    private static final Pattern REGEX_ELEMENTINDEX = Pattern.compile("^\\[([0-9]+)\\]");

    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        Matcher matcher = REGEX_ELEMENTINDEX.matcher(nbtPathExpression).region(pos, nbtPathExpression.length());
        if (!matcher.find()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        String childIndexString = matcher.group(1);
        int childIndex = Integer.parseInt(childIndexString);
        return new INbtPathExpressionParseHandler.HandleResult(new Expression(childIndex), 2 + childIndexString.length());
    }

    public static class Expression
    implements INbtPathExpression {
        private final int childIndex;

        public Expression(int childIndex) {
            this.childIndex = childIndex;
        }

        int getChildIndex() {
            return this.childIndex;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.map(executionContext -> {
                ListNBT tag;
                INBT nbt = executionContext.getCurrentTag();
                if (nbt.func_74732_a() == 9 && this.childIndex < (tag = (ListNBT)nbt).size()) {
                    INBT childTag = tag.get(this.getChildIndex());
                    return new NbtPathExpressionExecutionContext(childTag, (NbtPathExpressionExecutionContext)executionContext);
                }
                return null;
            }).filter(Objects::nonNull));
        }
    }
}

