/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.cyclops.cyclopscore.inventory.InventoryIterator;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;

public class PlayerExtendedInventoryIterator
implements Iterator<ItemStack> {
    public static final List<IInventoryExtender> INVENTORY_EXTENDERS = Lists.newArrayList();
    private final Queue<InventoryIterator> iterators = Queues.newArrayDeque();

    public PlayerExtendedInventoryIterator(PlayerEntity player) {
        this.iterators.add(new PlayerInventoryIterator(player));
        for (IInventoryExtender inventoryExtender : INVENTORY_EXTENDERS) {
            IItemHandlerModifiable inv = inventoryExtender.getInventory(player);
            if (inv == null) continue;
            this.iterators.add(new InventoryIterator(inv));
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterators.size() > 0 && this.iterators.peek().hasNext();
    }

    @Override
    public ItemStack next() {
        if (this.iterators.peek().hasNext()) {
            ItemStack next = this.iterators.peek().next();
            if (!this.iterators.peek().hasNext()) {
                this.iterators.poll();
            }
            return next;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented.");
    }

    public void replace(ItemStack itemStack) {
        this.iterators.peek().replace(itemStack);
    }

    public static interface IInventoryExtender {
        @Nullable
        public IItemHandlerModifiable getInventory(PlayerEntity var1);
    }
}

