/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public final class L10NHelpers {
    public static final int MAX_TOOLTIP_LINE_LENGTH = 25;
    private static final String KEY_ENABLED = "general.cyclopscore.info.enabled";
    private static final String KEY_DISABLED = "general.cyclopscore.info.disabled";

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String key, Object ... params) {
        if (MinecraftHelpers.isModdedEnvironment()) {
            return I18n.func_135052_a((String)key, (Object[])params);
        }
        return String.format("%s: %s", key, Arrays.toString(params));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addStatusInfo(List<ITextComponent> infoLines, boolean isEnabled, String statusPrefixKey) {
        TranslationTextComponent autoSupply = new TranslationTextComponent(KEY_DISABLED);
        if (isEnabled) {
            autoSupply = new TranslationTextComponent(KEY_ENABLED);
        }
        infoLines.add((ITextComponent)new TranslationTextComponent(statusPrefixKey, new Object[]{autoSupply}));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addOptionalInfo(List<ITextComponent> list, String prefix) {
        String key = prefix + ".info";
        if (I18n.func_188566_a((String)key)) {
            if (MinecraftHelpers.isShifted()) {
                String localized = L10NHelpers.localize(key, new Object[0]);
                list.addAll(StringHelpers.splitLines(localized, 25, IInformationProvider.INFO_PREFIX).stream().map(StringTextComponent::new).collect(Collectors.toList()));
            } else {
                list.add((ITextComponent)new TranslationTextComponent("general.cyclopscore.tooltip.info").func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY)).func_240722_b_(Boolean.valueOf(true))));
            }
        }
    }
}

