/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class DirectionHelpers {
    public static List<Direction> DIRECTIONS = Arrays.asList(Direction.values());
    public static Direction[][] TEXTURESIDE_ORIENTATION = new Direction[][]{{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}, {Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, {Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH}};
    private static Direction[][] FACING_ROTATIONS = new Direction[][]{{Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, {Direction.SOUTH, Direction.NORTH, Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}, {Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, {Direction.DOWN, Direction.UP, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH}};

    public static Iterator<Direction> getDirectionIterator() {
        return DIRECTIONS.iterator();
    }

    public static Direction getEntityFacingDirection(LivingEntity entity) {
        int facingDirection = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return Direction.func_176731_b((int)facingDirection);
    }

    public static Direction getEnumFacingFromXSign(int xSign) {
        return xSign > 0 ? Direction.EAST : Direction.WEST;
    }

    public static Direction getEnumFacingFromZSing(int zSign) {
        return zSign > 0 ? Direction.SOUTH : Direction.NORTH;
    }

    public static Direction transformFacingForRotation(Direction facing, Direction rotation) {
        return FACING_ROTATIONS[rotation.ordinal()][facing.ordinal()];
    }
}

