/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;

public abstract class ItemInventoryContainer<I extends Item>
extends ContainerExtended {
    protected I item;
    protected int itemIndex;
    protected Hand hand;

    public ItemInventoryContainer(@Nullable ContainerType<?> type, int id, PlayerInventory inventory, int itemIndex, Hand hand) {
        super(type, id, inventory);
        this.item = InventoryHelpers.getItemFromIndex(inventory.field_70458_d, itemIndex, hand).func_77973_b();
        this.itemIndex = itemIndex;
        this.hand = hand;
    }

    public static int readItemIndex(PacketBuffer packetBuffer) {
        return packetBuffer.readInt();
    }

    public static Hand readHand(PacketBuffer packetBuffer) {
        return packetBuffer.readBoolean() ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public I getItem() {
        return this.item;
    }

    public boolean func_75145_c(PlayerEntity player) {
        ItemStack item = this.getItemStack(player);
        return item != null && item.func_77973_b() == this.getItem();
    }

    public ItemStack getItemStack(PlayerEntity player) {
        return InventoryHelpers.getItemFromIndex(player, this.itemIndex, this.hand);
    }

    @Override
    protected Slot createNewSlot(IInventory inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y){

            public boolean func_82869_a(PlayerEntity player) {
                return this.func_75211_c() != InventoryHelpers.getItemFromIndex(player, ItemInventoryContainer.this.itemIndex, ItemInventoryContainer.this.hand);
            }
        };
    }

    @Override
    public ItemStack func_184996_a(int slotId, int arg, ClickType clickType, PlayerEntity player) {
        if (clickType == ClickType.SWAP && arg == this.itemIndex) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, arg, clickType, player);
    }
}

