/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import org.cyclops.cyclopscore.inventory.IValueNotifier;

public class ValueNotifierHelpers {
    public static String KEY = "v";

    public static void setValue(IValueNotifier notifier, int valueId, INBT value) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, int value) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, boolean value) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, String value) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(KEY, value);
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, IFormattableTextComponent value) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(KEY, ITextComponent.Serializer.func_150696_a((ITextComponent)value));
        notifier.setValue(valueId, tag);
    }

    public static void setValue(IValueNotifier notifier, int valueId, List<IFormattableTextComponent> values) {
        CompoundNBT tag = new CompoundNBT();
        ListNBT list = new ListNBT();
        for (ITextComponent iTextComponent : values) {
            list.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)iTextComponent)));
        }
        tag.func_218657_a(KEY, (INBT)list);
        notifier.setValue(valueId, tag);
    }

    @Nullable
    public static INBT getValueNbt(IValueNotifier notifier, int valueId) {
        CompoundNBT tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.func_74781_a(KEY);
        }
        return null;
    }

    public static int getValueInt(IValueNotifier notifier, int valueId) {
        CompoundNBT tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.func_74762_e(KEY);
        }
        return 0;
    }

    public static boolean getValueBoolean(IValueNotifier notifier, int valueId) {
        CompoundNBT tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.func_74767_n(KEY);
        }
        return false;
    }

    @Nullable
    public static String getValueString(IValueNotifier notifier, int valueId) {
        CompoundNBT tag = notifier.getValue(valueId);
        if (tag != null) {
            return tag.func_74779_i(KEY);
        }
        return null;
    }

    @Nullable
    public static IFormattableTextComponent getValueTextComponent(IValueNotifier notifier, int valueId) {
        CompoundNBT tag = notifier.getValue(valueId);
        if (tag != null) {
            return ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i(KEY));
        }
        return null;
    }

    @Nullable
    public static List<IFormattableTextComponent> getValueTextComponentList(IValueNotifier notifier, int valueId) {
        CompoundNBT tag = notifier.getValue(valueId);
        if (tag != null) {
            ListNBT listTag = tag.func_150295_c(KEY, 8);
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(ITextComponent.Serializer.func_240643_a_((String)listTag.func_150307_f(i)));
            }
            return list;
        }
        return null;
    }
}

