/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class TexturedProgress {
    protected final Screen parent;
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    protected final ResourceLocation texture;
    public int guiLeft;
    public int guiTop;
    public int max = 1;
    protected boolean topDown = true;

    public TexturedProgress(Screen parent, int x, int y, ResourceLocation texture) {
        this(parent, x, y, 14, 14, texture);
    }

    public TexturedProgress(Screen parent, int x, int y, int width, int height, ResourceLocation texture) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.texture = texture;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x <= mouseX && mouseX <= this.guiLeft + this.x + this.width && this.guiTop + this.y <= mouseY && mouseY <= this.guiTop + this.y + this.height;
    }

    public void draw(MatrixStack ms, float current) {
        this.parent.getMinecraft().func_110434_K().func_110577_a(this.texture);
        int relX = this.guiLeft + this.x;
        int relY = this.guiTop + this.y;
        if (this.topDown) {
            Screen.func_238463_a_((MatrixStack)ms, (int)relX, (int)relY, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (int)this.width, (int)(this.height * 2));
            int rHeight = this.height - (int)((float)this.height * Math.min(current / (float)this.max, 1.0f));
            Screen.func_238463_a_((MatrixStack)ms, (int)relX, (int)relY, (float)0.0f, (float)this.height, (int)this.width, (int)rHeight, (int)this.width, (int)(this.height * 2));
        } else {
            Screen.func_238463_a_((MatrixStack)ms, (int)relX, (int)relY, (float)0.0f, (float)this.height, (int)this.width, (int)this.height, (int)this.width, (int)(this.height * 2));
            int rWidth = (int)((float)this.width * Math.min(current / (float)this.max, 1.0f));
            if (current != 0.0f) {
                Screen.func_238463_a_((MatrixStack)ms, (int)relX, (int)relY, (float)0.0f, (float)0.0f, (int)(this.width - rWidth), (int)this.height, (int)this.width, (int)(this.height * 2));
            }
        }
    }

    public void renderHoveredToolTip(MatrixStack ms, int mouseX, int mouseY, int curr) {
        if (this.isMouseover(mouseX, mouseY) && curr > 0) {
            String display = "";
            int seconds = curr / 20;
            if (curr > 1200) {
                int minutes = seconds / 60;
                int remainder = seconds % 60;
                display = minutes + "m " + remainder + "s";
            } else {
                display = curr > 100 ? seconds + "s" : curr + "t";
            }
            ArrayList<TranslationTextComponent> list = new ArrayList<TranslationTextComponent>();
            list.add(new TranslationTextComponent(display));
            this.parent.func_243308_b(ms, list, mouseX, mouseY);
        }
    }

    public void setTopDown(boolean topDown) {
        this.topDown = topDown;
    }
}

