/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import com.lothrazar.cyclic.util.UtilEnchant;
import com.lothrazar.cyclic.util.UtilFakePlayer;
import java.util.Collections;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;

public class EnchantGloom
extends EnchantBase {
    private static final double BASE_ACTIVATION_CHANCE = 0.1;
    private static final double BASE_APPLY_CHANCE = 0.3;
    private static final double MIN_EFFECTS = 1.0;
    private static final double MAX_EFFECTS = 3.0;
    private static final int EFFECT_DURATION = 100;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "curse";

    public EnchantGloom(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 1;
    }

    public void func_151367_b(LivingEntity user, Entity attacker, int level) {
        if (user.field_70170_p.field_72995_K || !(attacker instanceof LivingEntity) || UtilFakePlayer.isFakePlayer(attacker)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        int totalLevels = this.getCurrentArmorLevelSlot(user, EquipmentSlotType.HEAD) + this.getCurrentArmorLevelSlot(user, EquipmentSlotType.CHEST) + this.getCurrentArmorLevelSlot(user, EquipmentSlotType.LEGS) + this.getCurrentArmorLevelSlot(user, EquipmentSlotType.FEET);
        double adjustedActivationChance = 0.1 / (double)totalLevels;
        if (adjustedActivationChance > user.field_70170_p.field_73012_v.nextDouble()) {
            List<Effect> negativeEffects = UtilEnchant.getNegativeEffects();
            Collections.shuffle(negativeEffects);
            int appliedEffects = 0;
            for (Effect effect : negativeEffects) {
                if (effect == null || !((double)appliedEffects < 1.0) && !(0.3 > user.field_70170_p.field_73012_v.nextDouble())) continue;
                livingAttacker.func_195064_c(new EffectInstance(effect, 100));
                if (!((double)(++appliedEffects) >= 3.0)) continue;
                break;
            }
        }
        super.func_151367_b(user, attacker, level);
    }
}

