/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.item;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.wireless.item.ContainerWirelessItem;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWirelessItem
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private int transferRate = 1;
    ItemStackHandler inventory = new ItemStackHandler(1);
    ItemStackHandler gpsSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() instanceof LocationGpsCard;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileWirelessItem() {
        super((TileEntityType)TileRegistry.WIRELESS_ITEM.get());
        this.needsRedstone = 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerWirelessItem(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        this.gpsSlots.deserializeNBT(tag.func_74775_l("invgps"));
        this.transferRate = tag.func_74762_e("transferRate");
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("transferRate", this.transferRate);
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        tag.func_218657_a("invgps", (INBT)this.gpsSlots.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean moved = false;
        BlockPosDim loc = this.getTargetInSlot();
        if (loc != null && UtilWorld.dimensionIsEqual(loc, this.field_145850_b)) {
            moved = this.moveItems(Direction.UP, loc.getPos(), this.transferRate, (IItemHandler)this.inventory, 0);
        }
        this.setLitProperty(moved);
    }

    BlockPosDim getTargetInSlot() {
        return LocationGpsCard.getPosition(this.gpsSlots.getStackInSlot(0));
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    public float getRed() {
        return 0.89f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public float getGreen() {
        return 0.12f;
    }

    public float getAlpha() {
        return 0.9f;
    }

    public float getThick() {
        return 0.065f;
    }

    static enum Fields {
        RENDER,
        TRANSFER_RATE,
        REDSTONE;

    }
}

