/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.packager;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.Tags;

public class UtilPackager {
    private static final Map<Item, ICraftingRecipe> fourItemRecipeCache = new HashMap<Item, ICraftingRecipe>();
    private static final Map<Item, ICraftingRecipe> nineItemRecipeCache = new HashMap<Item, ICraftingRecipe>();
    private static final Map<ICraftingRecipe, Integer> ingredientsInRecipeCache = new HashMap<ICraftingRecipe, Integer>();
    private static final Map<Item, Boolean> itemValidCache = new HashMap<Item, Boolean>();
    private static final Map<ICraftingRecipe, Boolean> recipeValidCache = new HashMap<ICraftingRecipe, Boolean>();

    private UtilPackager() {
    }

    private static Map<Item, ICraftingRecipe> getFourItemRecipeCache(RecipeManager recipeManager) {
        if (fourItemRecipeCache.isEmpty()) {
            UtilPackager.buildRecipeCaches(recipeManager);
        }
        return fourItemRecipeCache;
    }

    public static int getIngredientsInRecipe(ICraftingRecipe recipe) {
        return ingredientsInRecipeCache.computeIfAbsent(recipe, k -> {
            int count = 0;
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ItemStack[] matchingStacks;
                if (ingredient == Ingredient.field_193370_a || (matchingStacks = ingredient.func_193365_a()).length == 0) continue;
                ++count;
            }
            return count;
        });
    }

    private static Map<Item, ICraftingRecipe> getNineItemRecipeCache(RecipeManager recipeManager) {
        if (nineItemRecipeCache.isEmpty()) {
            UtilPackager.buildRecipeCaches(recipeManager);
        }
        return nineItemRecipeCache;
    }

    public static ICraftingRecipe getRecipeForItemStack(RecipeManager recipeManager, ItemStack itemStack) {
        ICraftingRecipe recipe;
        if (itemStack.func_190916_E() >= 9 && (recipe = UtilPackager.getNineItemRecipeCache(recipeManager).get(itemStack.func_77973_b())) != null) {
            return recipe;
        }
        if (itemStack.func_190916_E() >= 4) {
            return UtilPackager.getFourItemRecipeCache(recipeManager).get(itemStack.func_77973_b());
        }
        return null;
    }

    public static boolean isItemStackValid(RecipeManager recipeManager, ItemStack itemStack) {
        return itemValidCache.computeIfAbsent(itemStack.func_77973_b(), item -> UtilPackager.getFourItemRecipeCache(recipeManager).containsKey(item) || UtilPackager.getNineItemRecipeCache(recipeManager).containsKey(item));
    }

    public static boolean isRecipeValid(ICraftingRecipe recipe) {
        return recipeValidCache.computeIfAbsent(recipe, k -> {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput.func_77976_d() == 1 || recipeOutput.func_190916_E() != 1) {
                return false;
            }
            Ingredient mainIngredient = null;
            ItemStack mainIngredientStack = null;
            int count = 0;
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ItemStack[] matchingStacks;
                if (ingredient == Ingredient.field_193370_a || (matchingStacks = ingredient.func_193365_a()).length == 0) continue;
                ItemStack matchingStack = matchingStacks[0];
                if (mainIngredient != null && !mainIngredient.test(matchingStack)) {
                    return false;
                }
                mainIngredient = ingredient;
                mainIngredientStack = matchingStack;
                ++count;
            }
            if (mainIngredient == null) {
                return false;
            }
            boolean outIsStorage = recipeOutput.func_77973_b().func_206844_a((ITag)Tags.Items.STORAGE_BLOCKS);
            Item mainIngredientItem = mainIngredientStack.func_77973_b();
            boolean inIsIngot = mainIngredientItem.func_206844_a((ITag)Tags.Items.INGOTS);
            if (!outIsStorage && inIsIngot) {
                return false;
            }
            return count == 4 || count == 9;
        });
    }

    public static void buildRecipeCaches(RecipeManager recipeManager) {
        block0: for (ICraftingRecipe recipe : recipeManager.func_241447_a_(IRecipeType.field_222149_a)) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput.func_77976_d() == 1 || recipeOutput.func_190916_E() != 1) continue;
            Ingredient mainIngredient = null;
            ItemStack mainIngredientStack = null;
            int count = 0;
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient == Ingredient.field_193370_a) continue;
                ItemStack[] matchingStacks = ingredient.func_193365_a();
                if (matchingStacks.length != 1) {
                    recipeValidCache.put(recipe, false);
                    continue block0;
                }
                ItemStack matchingStack = matchingStacks[0];
                if (mainIngredient != null && !mainIngredient.test(matchingStack)) {
                    recipeValidCache.put(recipe, false);
                    continue block0;
                }
                mainIngredient = ingredient;
                mainIngredientStack = matchingStack;
                ++count;
            }
            if (mainIngredient == null) continue;
            boolean outIsStorage = recipeOutput.func_77973_b().func_206844_a((ITag)Tags.Items.STORAGE_BLOCKS);
            Item mainIngredientItem = mainIngredientStack.func_77973_b();
            boolean inIsIngot = mainIngredientItem.func_206844_a((ITag)Tags.Items.INGOTS);
            if (!outIsStorage && inIsIngot) continue;
            if (count == 4) {
                fourItemRecipeCache.put(mainIngredientItem, recipe);
                ingredientsInRecipeCache.put(recipe, 4);
                recipeValidCache.put(recipe, true);
                continue;
            }
            if (count == 9) {
                nineItemRecipeCache.put(mainIngredientItem, recipe);
                ingredientsInRecipeCache.put(recipe, 9);
                recipeValidCache.put(recipe, true);
                continue;
            }
            recipeValidCache.put(recipe, false);
        }
    }
}

