/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.laser;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.laser.ContainerLaser;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.OffsetEnum;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileLaser
extends TileEntityBase
implements INamedContainerProvider {
    protected OffsetEnum xOffset = OffsetEnum.CENTER;
    protected OffsetEnum yOffset = OffsetEnum.CENTER;
    protected OffsetEnum zOffset = OffsetEnum.CENTER;
    private int red = 255;
    private int green = 0;
    private int blue = 0;
    private int alpha = 70;
    private int thick = 8;
    ItemStackHandler inventory = new ItemStackHandler(4){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() instanceof LocationGpsCard;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileLaser() {
        super(TileRegistry.laser);
        this.needsRedstone = 0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerLaser(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    BlockPos getPosTarget() {
        BlockPosDim loc = LocationGpsCard.getPosition(this.inventory.getStackInSlot(0));
        if (loc != null && loc.getPos() != null) {
            return loc.getPos();
        }
        return this.func_174877_v();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case THICK: {
                return this.thick;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case BLUE: {
                return this.blue;
            }
            case GREEN: {
                return this.green;
            }
            case RED: {
                return this.red;
            }
            case ALPHA: {
                return this.alpha;
            }
            case XOFF: {
                return this.xOffset.ordinal();
            }
            case YOFF: {
                return this.yOffset.ordinal();
            }
            case ZOFF: {
                return this.zOffset.ordinal();
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case THICK: {
                this.thick = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case BLUE: {
                this.blue = value;
                break;
            }
            case GREEN: {
                this.green = value;
                break;
            }
            case RED: {
                this.red = value;
                break;
            }
            case ALPHA: {
                this.alpha = value;
                break;
            }
            case XOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.xOffset = OffsetEnum.values()[value];
                break;
            }
            case YOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.yOffset = OffsetEnum.values()[value];
                break;
            }
            case ZOFF: {
                if (value >= OffsetEnum.values().length) {
                    value = 0;
                }
                this.zOffset = OffsetEnum.values()[value];
            }
        }
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        this.red = tag.func_74762_e("red");
        this.green = tag.func_74762_e("green");
        this.blue = tag.func_74762_e("blue");
        this.alpha = tag.func_74762_e("alpha");
        this.thick = tag.func_74762_e("thick");
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("red", this.red);
        tag.func_74768_a("green", this.green);
        tag.func_74768_a("blue", this.blue);
        tag.func_74768_a("alpha", this.alpha);
        tag.func_74768_a("thick", this.thick);
        return super.func_189515_b(tag);
    }

    public float getRed() {
        return (float)this.red / 255.0f;
    }

    public float getBlue() {
        return (float)this.blue / 255.0f;
    }

    public float getGreen() {
        return (float)this.green / 255.0f;
    }

    public float getAlpha() {
        float a = this.alpha;
        return a / 100.0f;
    }

    public float getThick() {
        float t = this.thick;
        return t / 100.0f;
    }

    static enum Fields {
        REDSTONE,
        THICK,
        RED,
        GREEN,
        BLUE,
        ALPHA,
        XOFF,
        YOFF,
        ZOFF;

    }
}

