/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.hopper;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.hopperfluid.BlockFluidHopper;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSimpleHopper
extends TileEntityBase
implements ITickableTileEntity,
IHopper {
    ItemStackHandler inventory = new ItemStackHandler(1);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileSimpleHopper() {
        super((TileEntityType)TileRegistry.HOPPER.get());
    }

    public TileSimpleHopper(TileEntityType<? extends TileSimpleHopper> tileEntityType) {
        super(tileEntityType);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public void func_73660_a() {
        if (this.isPowered()) {
            return;
        }
        this.tryPullFromWorld(this.field_174879_c.func_177972_a(Direction.UP));
        this.tryExtract((IItemHandler)this.inventory, Direction.UP, this.getFlow(), null);
        Direction exportToSide = (Direction)this.func_195044_w().func_177229_b((Property)BlockFluidHopper.FACING);
        this.moveItemToCompost(exportToSide, this.inventory);
        this.moveItems(exportToSide, this.getFlow(), (IItemHandler)this.inventory);
    }

    public int getFlow() {
        return 1;
    }

    private int getRadius() {
        return 1;
    }

    private void tryPullFromWorld(BlockPos center) {
        int radius = this.getRadius();
        AxisAlignedBB aabb = new AxisAlignedBB((double)(center.func_177958_n() - radius), (double)center.func_177956_o(), (double)(center.func_177952_p() - radius), (double)(center.func_177958_n() + radius + 1), (double)(center.func_177956_o() + 1), (double)(center.func_177952_p() + radius + 1));
        List list = this.field_145850_b.func_175647_a(ItemEntity.class, aabb, entity -> entity.func_70089_S() && !entity.func_92059_d().func_190926_b());
        if (list.size() > 0) {
            ItemEntity stackEntity = (ItemEntity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            ItemStack remainder = stackEntity.func_92059_d();
            remainder = this.inventory.insertItem(0, remainder, false);
            stackEntity.func_92058_a(remainder);
            if (remainder.func_190926_b()) {
                stackEntity.func_70106_y();
            }
        }
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public double func_96107_aA() {
        return this.func_174877_v().func_177958_n();
    }

    public double func_96109_aB() {
        return this.func_174877_v().func_177956_o();
    }

    public double func_96108_aC() {
        return this.func_174877_v().func_177952_p();
    }
}

