/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.clock;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.clock.BlockRedstoneClock;
import com.lothrazar.cyclic.block.clock.ContainerClock;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TileRedstoneClock
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    private int delay;
    private int duration;
    private int power;
    private Map<Direction, Boolean> poweredSides = new HashMap<Direction, Boolean>();

    public TileRedstoneClock() {
        super(TileRegistry.clock);
        this.timer = 0;
        this.delay = 60;
        this.duration = 60;
        this.power = 15;
        this.needsRedstone = 0;
        this.facingResetAllOn();
    }

    public void func_73660_a() {
        try {
            this.updateMyState();
        }
        catch (Throwable e) {
            ModCyclic.LOGGER.error("Clock blockstate update error", e);
        }
    }

    private void facingResetAllOn() {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, true);
        }
    }

    public int getPower() {
        return this.power;
    }

    public int getPowerForSide(Direction side) {
        if (this.getSideHasPower(side)) {
            return this.power;
        }
        return 0;
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    private boolean detectAllOff() {
        boolean areAnyOn = false;
        for (Direction f : Direction.values()) {
            areAnyOn = areAnyOn || this.poweredSides.get(f) != false;
        }
        return !areAnyOn;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerClock(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.delay = tag.func_74762_e("redstone_delay");
        this.duration = tag.func_74762_e("redstone_duration");
        this.power = tag.func_74762_e("redstone_power");
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.func_74767_n(f.func_176742_j()));
        }
        if (this.detectAllOff()) {
            this.facingResetAllOn();
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("redstone_delay", this.delay);
        tag.func_74768_a("redstone_duration", this.duration);
        tag.func_74768_a("redstone_power", this.power);
        for (Direction f : Direction.values()) {
            tag.func_74757_a(f.func_176742_j(), this.poweredSides.get(f).booleanValue());
        }
        return super.func_189515_b(tag);
    }

    private void updateMyState() throws IllegalArgumentException {
        boolean powered;
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (!blockState.func_235901_b_((Property)BlockRedstoneClock.LIT)) {
            return;
        }
        if (this.power == 0) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BlockRedstoneClock.LIT, (Comparable)Boolean.valueOf(false)));
            return;
        }
        ++this.timer;
        boolean prevPowered = (Boolean)blockState.func_177229_b((Property)BlockRedstoneClock.LIT);
        if (this.timer < this.delay) {
            powered = false;
        } else if (this.timer < this.delay + this.duration) {
            powered = true;
        } else {
            this.timer = 0;
            powered = false;
        }
        if (prevPowered != powered) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)blockState.func_206870_a((Property)BlockRedstoneClock.LIT, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case POWER: {
                return this.power;
            }
            case TIMER: {
                return this.timer;
            }
            case DELAY: {
                return this.delay;
            }
            case DURATION: {
                return this.duration;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case POWER: {
                if (value < 0) {
                    value = 0;
                }
                if (value > 15) {
                    value = 15;
                }
                this.power = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case DELAY: {
                this.delay = Math.max(value, 1);
                break;
            }
            case DURATION: {
                this.duration = Math.max(value, 1);
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    static enum Fields {
        TIMER,
        DELAY,
        DURATION,
        POWER,
        REDSTONE,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

