/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.item;

import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.TileCableBase;
import com.lothrazar.cyclic.block.cable.item.ContainerCableItem;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableItem
extends TileCableBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int FLOW_QTY = 64;
    private int extractQty = 64;
    ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    private final IItemHandler itemHandler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return FilterCardItem.filterAllowsExtract(TileCableItem.this.filter.getStackInSlot(0), stack);
        }
    };
    private final LazyOptional<IItemHandler> itemCap = LazyOptional.of(() -> this.itemHandler);
    private final ConcurrentHashMap<Direction, LazyOptional<IItemHandler>> itemCapSides = new ConcurrentHashMap();

    public TileCableItem() {
        super(TileRegistry.item_pipeTile);
    }

    @Override
    public void updateConnection(Direction side, EnumConnectType connectType) {
        EnumConnectType oldConnectType = this.getConnectionType(side);
        if (connectType == EnumConnectType.BLOCKED && oldConnectType != EnumConnectType.BLOCKED) {
            LazyOptional<IItemHandler> sidedCap = this.itemCapSides.get(side);
            if (sidedCap != null) {
                sidedCap.invalidate();
            }
        } else if (oldConnectType == EnumConnectType.BLOCKED && connectType != EnumConnectType.BLOCKED) {
            this.itemCapSides.put(side, (LazyOptional<IItemHandler>)LazyOptional.of(() -> this.itemHandler));
        }
        super.updateConnection(side, connectType);
    }

    public void func_73660_a() {
        for (Direction extractSide : Direction.values()) {
            EnumConnectType connection = this.getConnectionType(extractSide);
            if (!connection.isExtraction()) continue;
            this.tryExtract(this.itemHandler, extractSide, this.extractQty, this.filter);
        }
        this.normalFlow();
    }

    private void normalFlow() {
        block0: for (Direction incomingSide : Direction.values()) {
            for (Direction outgoingSide : UtilDirection.getAllInDifferentOrder()) {
                EnumConnectType outgoingConnection;
                if (outgoingSide == incomingSide || (outgoingConnection = this.getConnectionType(outgoingSide)).isExtraction() || outgoingConnection.isBlocked() || !this.moveItems(outgoingSide, 64, this.itemHandler)) continue;
                continue block0;
            }
            this.moveItems(incomingSide, 64, this.itemHandler);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.itemCap.cast();
            }
            LazyOptional sidedCap = this.itemCapSides.get(side);
            if (sidedCap == null) {
                if (this.getConnectionType(side) != EnumConnectType.BLOCKED) {
                    sidedCap = LazyOptional.of(() -> this.itemHandler);
                    this.itemCapSides.put(side, (LazyOptional<IItemHandler>)sidedCap);
                    return sidedCap.cast();
                }
            } else {
                return sidedCap.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCap.invalidate();
        for (LazyOptional<IItemHandler> sidedCap : this.itemCapSides.values()) {
            sidedCap.invalidate();
        }
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.extractQty = tag.func_74762_e("extractCount");
        ((INBTSerializable)this.itemHandler).deserializeNBT((INBT)tag.func_74775_l("inv"));
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        tag.func_74768_a("extractCount", this.extractQty);
        tag.func_218657_a("inv", ((INBTSerializable)this.itemHandler).serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
        this.extractQty = value;
    }

    @Override
    public int getField(int field) {
        return this.extractQty;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCableItem(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

