/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.registry;

import com.lothrazar.cyclic.potion.TickableEffect;
import com.lothrazar.cyclic.potion.effect.StunEffect;
import com.lothrazar.cyclic.potion.effect.SwimEffect;
import com.lothrazar.cyclic.recipe.ModBrewingRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PotionRegistry {
    @SubscribeEvent
    public static void onPotEffectRegistry(RegistryEvent.Register<Effect> event) {
        IForgeRegistry r = event.getRegistry();
        PotionEffects.stun = PotionRegistry.register((IForgeRegistry<Effect>)r, new StunEffect(EffectType.HARMFUL, 0xCCCC00), "stun");
        PotionEffects.swimspeed = PotionRegistry.register((IForgeRegistry<Effect>)r, new SwimEffect(EffectType.BENEFICIAL, 0x663300), "swimspeed");
    }

    private static TickableEffect register(IForgeRegistry<Effect> r, TickableEffect pot, String name) {
        pot.setRegistryName(new ResourceLocation("cyclic", name));
        r.register((IForgeRegistryEntry)pot);
        PotionEffects.EFFECTS.add(pot);
        return pot;
    }

    @SubscribeEvent
    public static void onPotRegistry(RegistryEvent.Register<Potion> event) {
        IForgeRegistry r = event.getRegistry();
        int normal = 3600;
        int smal = 1800;
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_haste", new EffectInstance[]{new EffectInstance(Effects.field_76422_e, normal)}).setRegistryName("cyclic:haste")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_strong_haste", new EffectInstance[]{new EffectInstance(Effects.field_76422_e, smal, 1)}).setRegistryName("cyclic:strong_haste")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_stun", new EffectInstance[]{new EffectInstance((Effect)PotionEffects.stun, smal)}).setRegistryName("cyclic:stun")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_swimspeed", new EffectInstance[]{new EffectInstance((Effect)PotionEffects.swimspeed, normal)}).setRegistryName("cyclic:swimspeed")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_blind", new EffectInstance[]{new EffectInstance(Effects.field_76440_q, normal)}).setRegistryName("cyclic:blind")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_levitation", new EffectInstance[]{new EffectInstance(Effects.field_188424_y, smal)}).setRegistryName("cyclic:levitation")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_hunger", new EffectInstance[]{new EffectInstance(Effects.field_76438_s, normal)}).setRegistryName("cyclic:hunger")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_wither", new EffectInstance[]{new EffectInstance(Effects.field_82731_v, smal)}).setRegistryName("cyclic:wither")));
        r.register((IForgeRegistryEntry)((Potion)new Potion("cyclic_resistance", new EffectInstance[]{new EffectInstance(Effects.field_76429_m, smal)}).setRegistryName("cyclic:resistance")));
    }

    public static void setup(FMLCommonSetupEvent event) {
        ItemStack awkwardPotion = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185233_e);
        ItemStack thickPotion = PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185232_d);
        PotionRegistry.basicBrewing(awkwardPotion.func_77946_l(), PotionItem.haste, Items.field_151166_bC);
        PotionRegistry.basicBrewing(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)PotionItem.haste), PotionItem.strong_haste, Items.field_151137_ax);
        PotionRegistry.basicBrewing(awkwardPotion.func_77946_l(), PotionItem.stun, Items.field_221776_cx);
        PotionRegistry.basicBrewing(awkwardPotion.func_77946_l(), PotionItem.swimspeed, Items.field_222067_kP);
        PotionRegistry.basicBrewing(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185234_f), PotionItem.blind, Items.field_185164_cV);
        PotionRegistry.basicBrewing(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_204841_O), PotionItem.levitation, Items.field_151071_bq);
        PotionRegistry.basicBrewing(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185223_F), PotionItem.resistance, Items.field_151042_j);
        PotionRegistry.basicBrewing(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_185226_I), PotionItem.wither, Items.field_196154_dH);
        PotionRegistry.basicBrewing(thickPotion.func_77946_l(), PotionItem.hunger, Items.field_151078_bh);
    }

    private static void basicBrewing(ItemStack inputPot, Potion pot, Item item) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(inputPot, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)pot)));
    }

    static void splashBrewing(Potion pot, Item item) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)Potions.field_185233_e), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)}), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)pot)));
    }

    static void lingerBrewing(Potion pot, Item item) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ModBrewingRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)Potions.field_185233_e), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)item)}), PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185156_bI), (Potion)pot)));
    }

    public static class PotionEffects {
        public static final List<TickableEffect> EFFECTS = new ArrayList<TickableEffect>();
        @ObjectHolder(value="cyclic:stun")
        public static TickableEffect stun;
        @ObjectHolder(value="cyclic:swimspeed")
        public static TickableEffect swimspeed;
    }

    public static class PotionItem {
        @ObjectHolder(value="cyclic:strong_haste")
        public static Potion strong_haste;
        @ObjectHolder(value="cyclic:haste")
        public static Potion haste;
        @ObjectHolder(value="cyclic:stun")
        public static Potion stun;
        @ObjectHolder(value="cyclic:swimspeed")
        public static Potion swimspeed;
        @ObjectHolder(value="cyclic:blind")
        public static Potion blind;
        @ObjectHolder(value="cyclic:levitation")
        public static Potion levitation;
        @ObjectHolder(value="cyclic:hunger")
        public static Potion hunger;
        @ObjectHolder(value="cyclic:wither")
        public static Potion wither;
        @ObjectHolder(value="cyclic:resistance")
        public static Potion resistance;
    }
}

