/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRotateBlock
extends PacketBase {
    private BlockPos pos;
    private Direction side;
    private Hand hand;

    public PacketRotateBlock(BlockPos mouseover, Direction s, Hand hand) {
        this.pos = mouseover;
        this.side = s;
        this.hand = hand;
    }

    public static PacketRotateBlock decode(PacketBuffer buf) {
        return new PacketRotateBlock(buf.func_179259_c(), Direction.values()[buf.readInt()], Hand.values()[buf.readInt()]);
    }

    public static void encode(PacketRotateBlock msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.side.ordinal());
        buf.writeInt(msg.hand.ordinal());
    }

    public static void handle(PacketRotateBlock message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            boolean succ = UtilPlaceBlocks.rotateBlockValidState(world, message.pos, message.side);
            if (succ) {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ItemStack itemStackHeld = player.func_184586_b(message.hand);
                UtilItemStack.damageItem((LivingEntity)player, itemStackHeld);
                if (world.func_180495_p(message.pos).func_215695_r() != null) {
                    UtilSound.playSoundFromServer(player, world.func_180495_p(message.pos).func_215695_r().func_185841_e());
                }
            }
        });
        message.done(ctx);
    }
}

