/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.block.soundrecord.TileSoundRecorder;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRecordSound
extends PacketBase {
    private String sound;
    private BlockPos pos;

    public PacketRecordSound(String s, BlockPos n) {
        this.sound = s;
        this.pos = n;
    }

    public static PacketRecordSound decode(PacketBuffer buf) {
        String s = buf.func_218666_n();
        CompoundNBT tags = buf.func_150793_b();
        return new PacketRecordSound(s, new BlockPos(tags.func_74762_e("x"), tags.func_74762_e("y"), tags.func_74762_e("z")));
    }

    public static void encode(PacketRecordSound msg, PacketBuffer buf) {
        buf.func_180714_a(msg.sound);
        CompoundNBT tags = new CompoundNBT();
        tags.func_74768_a("x", msg.pos.func_177958_n());
        tags.func_74768_a("y", msg.pos.func_177956_o());
        tags.func_74768_a("z", msg.pos.func_177952_p());
        buf.func_150786_a(tags);
    }

    public static void handle(PacketRecordSound message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            TileEntity tile = sender.field_70170_p.func_175625_s(message.pos);
            if (tile instanceof TileSoundRecorder) {
                ((TileSoundRecorder)tile).onSoundHeard(message.sound);
            }
        });
        message.done(ctx);
    }
}

