/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.storagebag;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.storagebag.DepositMode;
import com.lothrazar.cyclic.item.storagebag.PickupMode;
import com.lothrazar.cyclic.item.storagebag.RefillMode;
import com.lothrazar.cyclic.item.storagebag.ScreenStorageBag;
import com.lothrazar.cyclic.item.storagebag.StorageBagCapability;
import com.lothrazar.cyclic.item.storagebag.StorageBagContainerProvider;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemStorageBag
extends ItemBase {
    private static final String NBT_COLOUR = "COLOUR";
    public static final int REFILL_TICKS = 4;
    public static final int SLOTS = 81;
    public int timer = 0;

    public ItemStorageBag(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K && !playerIn.func_213453_ef()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new StorageBagContainerProvider(), (BlockPos)playerIn.func_233580_cy_());
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static void setColour(ItemStack stack, DyeColor col) {
        CompoundNBT tags = stack.func_196082_o();
        tags.func_74768_a(NBT_COLOUR, col.getColorValue());
    }

    public static int getColour(ItemStack stack) {
        CompoundNBT tags = stack.func_196082_o();
        if (!tags.func_74764_b(NBT_COLOUR)) {
            return DyeColor.BROWN.getColorValue();
        }
        return tags.func_74762_e(NBT_COLOUR);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        Direction face = context.func_196000_l();
        World world = context.func_195991_k();
        TileEntity te = world.func_175625_s(pos);
        ItemStack bag = context.func_195996_i();
        DepositMode mode = ItemStorageBag.getDepositMode(bag);
        if (mode == DepositMode.NOTHING) {
            return ActionResultType.PASS;
        }
        ItemStackHandler handler = ItemStorageBag.getInventory(bag);
        if (handler != null && te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent()) {
            IItemHandler teHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).orElse(null);
            HashSet<Item> itemsInTargetInventory = new HashSet<Item>();
            if (teHandler != null) {
                for (int j = 0; j < teHandler.getSlots(); ++j) {
                    itemsInTargetInventory.add(teHandler.getStackInSlot(j).func_77973_b());
                }
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                ItemStack remaining = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.func_190916_E());
                if (stack.func_190926_b() || mode != DepositMode.DUMP && (mode != DepositMode.MERGE || !itemsInTargetInventory.contains(stack.func_77973_b()))) continue;
                remaining = ItemHandlerHelper.insertItem((IItemHandler)teHandler, (ItemStack)stack, (boolean)false);
                handler.setStackInSlot(i, remaining);
            }
            UtilSound.playSound((Entity)context.func_195999_j(), SoundRegistry.BASEY);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT nbt = stack.func_196082_o();
        String pickupMode = nbt.func_74779_i("pickup_mode");
        String depositMode = nbt.func_74779_i("deposit_mode");
        String refillMode = nbt.func_74779_i("refill_mode");
        if (!pickupMode.equals("")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.cyclic.storage_bag.tooltip.pickup", new Object[]{new TranslationTextComponent(String.format(pickupMode.equals("nothing") ? "item.cyclic.storage_bag.disabled" : "item.cyclic.storage_bag.pickup.%s", pickupMode))}).func_240699_a_(TextFormatting.GREEN));
        }
        if (!depositMode.equals("")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.cyclic.storage_bag.tooltip.deposit", new Object[]{new TranslationTextComponent(String.format(depositMode.equals("nothing") ? "item.cyclic.storage_bag.disabled" : "item.cyclic.storage_bag.deposit.%s", depositMode))}).func_240699_a_(TextFormatting.BLUE));
        }
        if (!refillMode.equals("")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.cyclic.storage_bag.tooltip.refill", new Object[]{new TranslationTextComponent(String.format(refillMode.equals("nothing") ? "item.cyclic.storage_bag.disabled" : "item.cyclic.storage_bag.refill.%s", refillMode))}).func_240699_a_(TextFormatting.RED));
        }
    }

    @Override
    public void registerClient() {
        ScreenManager.func_216911_a(ContainerScreenRegistry.STORAGE_BAG, ScreenStorageBag::new);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new StorageBagCapability(stack, nbt);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        ++this.timer;
        if (this.timer < 4) {
            return;
        }
        this.timer = 0;
        if (!world.field_72995_K && entity instanceof PlayerEntity && ItemStorageBag.getRefillMode(stack) == RefillMode.HOTBAR) {
            this.tryRefillHotbar(stack, (PlayerEntity)entity);
        }
    }

    private void tryRefillHotbar(ItemStack bag, PlayerEntity player) {
        ItemStackHandler handler = ItemStorageBag.getInventory(bag);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < Math.min(9, player.field_71071_by.func_70302_i_()); ++i) {
            boolean success;
            int slot;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || (slot = ItemStorageBag.getLastSlotWithStack(bag, stack)) == -1 || !(success = this.refillHotbar(bag, player, slot, i))) continue;
            handler.extractItem(slot, 1, false);
            return;
        }
    }

    private boolean refillHotbar(ItemStack bag, PlayerEntity player, int bagSlot, int invSlot) {
        ItemStackHandler handler = ItemStorageBag.getInventory(bag);
        boolean success = false;
        if (handler != null) {
            ItemStack extracted = handler.extractItem(bagSlot, 1, true);
            success = player.field_71071_by.func_191971_c(invSlot, extracted);
        }
        return success;
    }

    private static ItemStackHandler getInventory(ItemStack bag) {
        if (bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return (ItemStackHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get();
        }
        return null;
    }

    public static ItemStack tryInsert(ItemStack bag, ItemStack stack) {
        AtomicReference<ItemStack> returnStack = new AtomicReference<ItemStack>(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)stack.func_190916_E()));
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> returnStack.set(ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack, (boolean)false)));
        return returnStack.get();
    }

    public static ItemStack tryFilteredInsert(ItemStack bag, ItemStack stack) {
        if (bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent() && ItemStorageBag.bagHasItem(bag, stack)) {
            return ItemStorageBag.tryInsert(bag, stack);
        }
        return stack;
    }

    private static boolean bagHasItem(ItemStack bag, ItemStack stack) {
        AtomicBoolean hasItem = new AtomicBoolean(false);
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).func_77973_b() != stack.func_77973_b()) continue;
                hasItem.set(true);
            }
        });
        return hasItem.get();
    }

    public static int getFirstSlotWithStack(ItemStack bag, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = 0; i < h.getSlots(); ++i) {
                if (h.getStackInSlot(i).func_77973_b() != stack.func_77973_b()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    private static int getLastSlotWithStack(ItemStack bag, ItemStack stack) {
        AtomicInteger slot = new AtomicInteger(-1);
        bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
            for (int i = h.getSlots() - 1; i >= 0; --i) {
                if (h.getStackInSlot(i).func_77973_b() != stack.func_77973_b()) continue;
                slot.set(i);
            }
        });
        return slot.get();
    }

    public static PickupMode getPickupMode(ItemStack stack) {
        String mode = stack.func_196082_o().func_74779_i("pickup_mode");
        for (int i = 0; i < PickupMode.values().length; ++i) {
            if (!mode.equals(PickupMode.values()[i].func_176610_l())) continue;
            return PickupMode.values()[i];
        }
        return PickupMode.NOTHING;
    }

    private static DepositMode getDepositMode(ItemStack stack) {
        String mode = stack.func_196082_o().func_74779_i("deposit_mode");
        for (int i = 0; i < DepositMode.values().length; ++i) {
            if (!mode.equals(DepositMode.values()[i].func_176610_l())) continue;
            return DepositMode.values()[i];
        }
        return DepositMode.NOTHING;
    }

    private static RefillMode getRefillMode(ItemStack stack) {
        String mode = stack.func_196082_o().func_150285_a_();
        for (int i = 0; i < RefillMode.values().length; ++i) {
            if (!mode.equals(RefillMode.values()[i].func_176610_l())) continue;
            return RefillMode.values()[i];
        }
        return RefillMode.NOTHING;
    }

    public static List<Integer> getAllBagSlots(PlayerEntity player) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!ItemStorageBag.isBag(player.field_71071_by.func_70301_a(i))) continue;
            slots.add(i);
        }
        return slots;
    }

    public static int getFirstBagSlot(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (!ItemStorageBag.isBag(player.field_71071_by.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean isBag(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemStorageBag;
    }

    public static void setTimestamp(ItemStack myBag) {
        if (myBag.func_190926_b()) {
            return;
        }
        myBag.func_196082_o().func_74772_a("ts", System.currentTimeMillis());
    }
}

