/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.random;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.random.PacketRandomize;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RandomizerItem
extends ItemBase {
    private static final int COOLDOWN = 15;

    public RandomizerItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200918_c(4096));
    }

    public static ItemStack getIfHeld(PlayerEntity player) {
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof RandomizerItem) {
            return heldItem;
        }
        heldItem = player.func_184592_cb();
        if (heldItem.func_77973_b() instanceof RandomizerItem) {
            return heldItem;
        }
        return ItemStack.field_190927_a;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return super.func_195939_a(context);
        }
        BlockPos pos = context.func_195995_a();
        Direction side = context.func_196000_l();
        if (player.field_70170_p.field_72995_K) {
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketRandomize(pos, side, context.func_221531_n()));
        }
        UtilEntity.setCooldownItem(player, this, 15);
        return super.func_195939_a(context);
    }

    public static List<BlockPos> getPlaces(BlockPos pos, Direction side) {
        List<BlockPos> places = new ArrayList<BlockPos>();
        int xMin = pos.func_177958_n();
        int yMin = pos.func_177956_o();
        int zMin = pos.func_177952_p();
        int xMax = pos.func_177958_n();
        int yMax = pos.func_177956_o();
        int zMax = pos.func_177952_p();
        boolean isVertical = side == Direction.UP || side == Direction.DOWN;
        int offsetRadius = 0;
        offsetRadius = 2;
        if (offsetRadius > 0) {
            if (isVertical) {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                zMin -= offsetRadius;
                zMax += offsetRadius;
            } else if (side == Direction.EAST || side == Direction.WEST) {
                zMin -= offsetRadius;
                zMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            } else {
                xMin -= offsetRadius;
                xMax += offsetRadius;
                yMin -= offsetRadius;
                yMax += offsetRadius;
            }
            places = UtilWorld.getPositionsInRange(pos, xMin, xMax, yMin, yMax, zMin, zMax);
        }
        return places;
    }

    public static boolean canMove(BlockState stateHere, World world, BlockPos p) {
        if (stateHere.func_185887_b((IBlockReader)world, p) < 0.0f) {
            return false;
        }
        return world.func_175625_s(p) == null && !world.func_175623_d(p) && !stateHere.func_185904_a().func_76224_d();
    }
}

