/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.random;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.item.random.RandomizerItem;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRandomize
extends PacketBase {
    private BlockPos pos;
    private Direction side;
    private Hand hand;

    public PacketRandomize(BlockPos pos, Direction side, Hand h) {
        this.pos = pos;
        this.side = side;
        this.hand = h;
    }

    public static PacketRandomize decode(PacketBuffer buf) {
        PacketRandomize p = new PacketRandomize(buf.func_179259_c(), Direction.values()[buf.readInt()], Hand.values()[buf.readInt()]);
        return p;
    }

    public static void encode(PacketRandomize msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.side.ordinal());
        buf.writeInt(msg.hand.ordinal());
    }

    public static void handle(PacketRandomize message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.func_130014_f_();
            List<BlockPos> places = RandomizerItem.getPlaces(message.pos, message.side);
            ArrayList<BlockPos> rpos = new ArrayList<BlockPos>();
            ArrayList<BlockState> rstates = new ArrayList<BlockState>();
            BlockState stateHere = null;
            boolean atLeastOne = false;
            for (BlockPos p : places) {
                stateHere = world.func_180495_p(p);
                boolean canMove = RandomizerItem.canMove(stateHere, world, p);
                if (!canMove) continue;
                rpos.add(p);
                rstates.add(stateHere);
            }
            Collections.shuffle(rpos, world.field_73012_v);
            ArrayList<BlockPos> arrayList = rpos;
            synchronized (arrayList) {
                for (int i = 0; i < rpos.size(); ++i) {
                    BlockPos swapPos = (BlockPos)rpos.get(i);
                    BlockState swapState = (BlockState)rstates.get(i);
                    world.func_175655_b(swapPos, false);
                    if (!UtilPlaceBlocks.placeStateSafe(world, (PlayerEntity)player, swapPos, swapState, false)) continue;
                    atLeastOne = true;
                }
            }
            if (atLeastOne) {
                UtilItemStack.damageItem((LivingEntity)player, player.func_184586_b(message.hand));
            }
        });
        message.done(ctx);
    }
}

