/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.magicnet;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.registry.EntityRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilString;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityMagicNetEmpty
extends ProjectileItemEntity {
    public static final String NBT_ENTITYID = "cyclic:magicnet_id";
    public static final int PARTICLE_CAPTURE_COUNT = 8;

    public EntityMagicNetEmpty(EntityType<? extends ProjectileItemEntity> entityType, World world) {
        super(entityType, world);
    }

    public EntityMagicNetEmpty(World worldIn, LivingEntity livingEntityIn) {
        super(EntityRegistry.NETBALL, livingEntityIn, worldIn);
    }

    protected Item func_213885_i() {
        return ItemRegistry.magic_net;
    }

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type type = result.func_216346_c();
        BasicParticleType particleType = null;
        double targetHeightOffset = 0.0;
        if (type == RayTraceResult.Type.ENTITY) {
            EntityRayTraceResult entityRayTrace = (EntityRayTraceResult)result;
            Entity target = entityRayTrace.func_216348_a();
            if (target instanceof PlayerEntity || !target.func_70089_S()) {
                return;
            }
            if (target instanceof LivingEntity) {
                ((LivingEntity)target).func_213366_dy();
            }
            CompoundNBT compound = new CompoundNBT();
            target.func_70039_c(compound);
            if (target.func_200600_R() == EntityType.field_200773_M || target.func_200600_R() == EntityType.field_200774_N || target.func_200600_R() == EntityType.field_200775_O || target.func_200600_R() == EntityType.field_200776_P) {
                return;
            }
            String id = EntityType.func_200718_a((EntityType)target.func_200600_R()).toString();
            if (UtilString.isInList(ConfigRegistry.getMagicNetList(), EntityType.func_200718_a((EntityType)target.func_200600_R()))) {
                ModCyclic.LOGGER.info("ignored by: CONFIG LIST" + id);
                return;
            }
            compound.func_74778_a(NBT_ENTITYID, id);
            ItemStack drop = new ItemStack((IItemProvider)ItemRegistry.mob_container);
            drop.func_77982_d(compound);
            targetHeightOffset = target.func_213302_cg() / 2.0f;
            particleType = ParticleTypes.field_197599_J;
            UtilItemStack.drop(this.field_70170_p, this.func_233580_cy_(), drop);
            UtilSound.playSound(target, SoundRegistry.MONSTER_BALL_CAPTURE);
            target.func_70106_y();
        } else if (type == RayTraceResult.Type.BLOCK) {
            BlockPos pos = this.func_233580_cy_();
            targetHeightOffset = 0.0;
            particleType = ParticleTypes.field_197598_I;
            UtilItemStack.drop(this.field_70170_p, pos, new ItemStack((IItemProvider)ItemRegistry.magic_net));
        }
        if (particleType != null) {
            Vector3d hitVec = result.func_216347_e();
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)particleType, hitVec.func_82615_a(), hitVec.func_82617_b() + targetHeightOffset, hitVec.func_82616_c(), this.field_70146_Z.nextGaussian() * 0.1, 0.0, this.field_70146_Z.nextGaussian() * 0.1);
            }
        }
        this.func_70106_y();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

