/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.enderbook;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.enderbook.CapabilityProviderEnderBook;
import com.lothrazar.cyclic.item.enderbook.ContainerProviderEnderBook;
import com.lothrazar.cyclic.item.enderbook.ScreenEnderBook;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilEntity;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.List;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EnderBookItem
extends ItemBase {
    private static final String ITEMCOUNT = "itemCount";
    private static final int TP_COUNTDOWN = 60;
    private static final String ENDERSLOT = "enderslot";
    private static final String TELEPORT_COUNTDOWN = "TeleportCountdown";

    public EnderBookItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT stackTag;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && (stackTag = stack.func_196082_o()).func_74764_b(ITEMCOUNT)) {
            int itemCount = stackTag.func_74762_e(ITEMCOUNT);
            TranslationTextComponent t = new TranslationTextComponent("cyclic.screen.filter.item.count");
            t.func_240702_b_("" + itemCount);
            t.func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)t);
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TELEPORT_COUNTDOWN)) {
            return true;
        }
        return super.func_77636_d(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        int enderslot;
        BlockPosDim loc;
        ItemStack stack;
        if (!worldIn.field_72995_K && !playerIn.func_213453_ef()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)new ContainerProviderEnderBook(), (BlockPos)playerIn.func_233580_cy_());
        }
        if (!worldIn.field_72995_K && playerIn.func_213453_ef() && (stack = playerIn.func_184586_b(handIn)).func_77952_i() < stack.func_77958_k() - 1 && (loc = EnderBookItem.getLocation(stack, enderslot = stack.func_77978_p().func_74762_e(ENDERSLOT))) != null) {
            UtilChat.addServerChatMessage(playerIn, new TranslationTextComponent("item.cyclic.ender_book.start").func_240702_b_(loc.toString()));
            stack.func_196082_o().func_74768_a(TELEPORT_COUNTDOWN, 60);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(TELEPORT_COUNTDOWN) && entityIn instanceof LivingEntity) {
            int ct = stack.func_196082_o().func_74762_e(TELEPORT_COUNTDOWN);
            if (ct < 0) {
                EnderBookItem.cancelTeleport(stack);
                return;
            }
            if (ct == 0 && entityIn instanceof PlayerEntity) {
                PlayerEntity p = (PlayerEntity)entityIn;
                EnderBookItem.cancelTeleport(stack);
                int enderslot = stack.func_77978_p().func_74762_e(ENDERSLOT);
                BlockPosDim loc = EnderBookItem.getLocation(stack, enderslot);
                if (loc != null && loc.getPos() != null) {
                    if (loc.getDimension().equalsIgnoreCase(UtilWorld.dimensionToString(worldIn))) {
                        UtilEntity.enderTeleportEvent((LivingEntity)p, worldIn, loc.getPos());
                    } else if (!worldIn.field_72995_K) {
                        UtilEntity.dimensionTeleport((ServerPlayerEntity)p, (ServerWorld)worldIn, loc);
                    }
                    UtilItemStack.damageItem((LivingEntity)p, stack);
                    return;
                }
            } else if (ct % 20 == 0 && entityIn instanceof PlayerEntity) {
                UtilChat.sendStatusMessage((PlayerEntity)entityIn, (ITextComponent)new TranslationTextComponent("item.cyclic.ender_book.countdown").func_240702_b_("" + ct / 20));
            }
            stack.func_196082_o().func_74768_a(TELEPORT_COUNTDOWN, --ct);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == Items.field_151079_bi;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public static void cancelTeleport(ItemStack stack) {
        stack.func_196082_o().func_82580_o(TELEPORT_COUNTDOWN);
    }

    private static BlockPosDim getLocation(ItemStack stack, int enderSlot) {
        IItemHandler cap = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (cap != null) {
            return LocationGpsCard.getPosition(cap.getStackInSlot(enderSlot));
        }
        return null;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new CapabilityProviderEnderBook();
    }

    @Override
    public void registerClient() {
        ScreenManager.func_216911_a(ContainerScreenRegistry.ender_book, ScreenEnderBook::new);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        IItemHandler cap = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (cap != null) {
            int count = 0;
            for (int i = 0; i < cap.getSlots(); ++i) {
                if (cap.getStackInSlot(i).func_190926_b()) continue;
                ++count;
            }
            nbt.func_74768_a(ITEMCOUNT, count);
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbt) {
        if (nbt != null) {
            CompoundNBT stackTag = stack.func_196082_o();
            stackTag.func_74768_a(ITEMCOUNT, nbt.func_74762_e(ITEMCOUNT));
        }
        super.readShareTag(stack, nbt);
    }

    public static void scroll(ServerPlayerEntity player, int slot, boolean isDown) {
        ItemStack book = player.field_71071_by.func_70301_a(slot);
        if (book.func_77942_o()) {
            int enderslot = book.func_77978_p().func_74762_e(ENDERSLOT);
            enderslot = EnderBookItem.scrollSlot(isDown, enderslot);
            book.func_77978_p().func_74768_a(ENDERSLOT, enderslot % 9);
            BlockPosDim loc = EnderBookItem.getLocation(book, enderslot);
            String msg = "---";
            if (loc != null) {
                msg = loc.getDisplayString();
            }
            UtilChat.addServerChatMessage((PlayerEntity)player, new StringTextComponent(book.func_77978_p().func_74762_e(ENDERSLOT) + " : ").func_240702_b_(msg));
        }
    }

    private static int scrollSlot(boolean isDown, int enderslot) {
        if ((enderslot += isDown ? -1 : 1) < 0) {
            enderslot = 8;
        } else if (enderslot >= 9) {
            enderslot = 0;
        }
        return enderslot;
    }
}

