/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.bauble;

import com.lothrazar.cyclic.item.bauble.ItemBaseToggle;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;

public class AutoCaveTorchItem
extends ItemBaseToggle {
    private static final int TORCH_LIGHT_LEVEL = 14;
    private static final int TICK_DELAY = 2;
    private static final int BLOCKS_TO_MOVE_FEET_DOWN = 2;
    public static ForgeConfigSpec.IntValue LIGHT_LIMIT;
    public static ForgeConfigSpec.IntValue LIGHT_TARGET;
    public static ForgeConfigSpec.BooleanValue PREFER_WALLS;
    public static ForgeConfigSpec.BooleanValue PREFER_LEFT_WALL;
    private final AtomicInteger timer = new AtomicInteger();
    private final Lock lock = new ReentrantLock();

    public AutoCaveTorchItem(Item.Properties properties) {
        super(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_77663_a(ItemStack stack, World world, Entity entityIn, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        if (!this.isOn(stack)) {
            return;
        }
        if (!(entityIn instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        if (player.func_175149_v()) {
            return;
        }
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            stack.func_196085_b(stack.func_77958_k());
            return;
        }
        if (this.timer.updateAndGet(n -> Math.max(n - 1, 0)) == 0 && this.lock.tryLock()) {
            try {
                this.placeTorchIfNecessary(stack, world, player);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.tryRepairWith(stack, player, Blocks.field_150478_aa.func_199767_j());
    }

    private void placeTorchIfNecessary(ItemStack stack, World world, PlayerEntity player) {
        BlockPos next;
        BlockPos playerPos = player.func_233580_cy_();
        if (world.func_180495_p(playerPos).func_200132_m()) {
            return;
        }
        for (int i = 0; i < 2 && !world.func_180495_p(next = playerPos.func_177977_b()).func_200132_m(); ++i) {
            playerPos = next;
        }
        if (!world.func_180495_p(playerPos.func_177977_b()).func_200132_m()) {
            return;
        }
        int lightLimit = AutoCaveTorchItem.getLightLimit();
        int playerPosLight = world.func_201696_r(playerPos);
        world.func_226658_a_(LightType.BLOCK, playerPos);
        if (playerPosLight > lightLimit) {
            return;
        }
        int lightTarget = AutoCaveTorchItem.getLightTarget() + lightLimit - playerPosLight;
        int targetDistance = 14 - lightTarget;
        int fallbackTargetDistance = 14 - (lightLimit + 1);
        assert (targetDistance <= fallbackTargetDistance);
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashMap<BlockPos, Integer> distances = new HashMap<BlockPos, Integer>();
        queue.add(playerPos);
        distances.put(playerPos, 0);
        int playerElevation = playerPos.func_177956_o();
        ArrayList<TorchPos> validTorchPositions = this.bfs(world, queue, distances, targetDistance, fallbackTargetDistance, playerElevation);
        boolean preferWalls = AutoCaveTorchItem.isPreferWalls();
        validTorchPositions.sort(Comparator.comparing(torchPos -> preferWalls && torchPos.isNotOnGround() && torchPos.isNotBelowFeet()).thenComparing(torchPos -> -(torchPos.currentLightLevel + (torchPos.isNotBelowFeet() ? 2 : 4) * Math.abs(torchPos.relativeHeight))).thenComparing(torchPos -> -torchPos.playerLightLevel).thenComparing(TorchPos::isNotOnGround).reversed());
        Direction facing = player.func_174811_aO();
        for (TorchPos torchPos2 : validTorchPositions) {
            if (!UtilPlaceBlocks.placeTorchSafely(world, torchPos2.pos, torchPos2.getPlacementDirection(facing))) continue;
            UtilItemStack.damageItem((LivingEntity)player, stack);
            this.timer.set(2);
            return;
        }
        validTorchPositions = this.bfs(world, queue, distances, fallbackTargetDistance, fallbackTargetDistance, playerElevation);
        validTorchPositions.sort(Comparator.comparing(torchPos -> torchPos.playerLightLevel).thenComparing(torchPos -> preferWalls && torchPos.isNotOnGround() && torchPos.isNotBelowFeet()).thenComparing(torchPos -> -(torchPos.currentLightLevel + (torchPos.isNotBelowFeet() ? 2 : 4) * Math.abs(torchPos.relativeHeight))).thenComparing(TorchPos::isNotOnGround).reversed());
        for (TorchPos torchPos2 : validTorchPositions) {
            if (!UtilPlaceBlocks.placeTorchSafely(world, torchPos2.pos, torchPos2.getPlacementDirection(facing))) continue;
            UtilItemStack.damageItem((LivingEntity)player, stack);
            this.timer.set(2);
            return;
        }
        this.timer.set(2);
    }

    private ArrayList<TorchPos> bfs(World world, Queue<BlockPos> queue, HashMap<BlockPos, Integer> distances, int maxPoppedDist, int maxPushedDist, int playerElevation) {
        BlockPos poppedPos;
        int poppedDistance;
        ArrayList<TorchPos> validTorchPositions = new ArrayList<TorchPos>();
        while (!queue.isEmpty() && (poppedDistance = distances.get(poppedPos = queue.peek()).intValue()) <= maxPoppedDist) {
            queue.remove();
            boolean isValidTorch = false;
            boolean wouldUpdateFloatingFallingBlock = false;
            EnumSet<Direction> solidDirections = EnumSet.noneOf(Direction.class);
            for (Direction direction : Direction.values()) {
                BlockPos nextPos = poppedPos.func_177972_a(direction);
                BlockState state = world.func_180495_p(nextPos);
                if (state.func_200132_m()) {
                    solidDirections.add(direction);
                    if (direction != Direction.UP) {
                        isValidTorch = true;
                    }
                } else if (poppedDistance < maxPushedDist && !distances.containsKey(nextPos)) {
                    distances.put(nextPos, poppedDistance + 1);
                    queue.add(nextPos);
                }
                if (direction == Direction.UP || !(state.func_177230_c() instanceof FallingBlock) || !FallingBlock.func_185759_i((BlockState)world.func_180495_p(nextPos.func_177977_b()))) continue;
                wouldUpdateFloatingFallingBlock = true;
            }
            if (!isValidTorch || wouldUpdateFloatingFallingBlock || !world.func_175623_d(poppedPos)) continue;
            validTorchPositions.add(new TorchPos(poppedPos, poppedPos.func_177956_o() - playerElevation, 14 - poppedDistance, world.func_201696_r(poppedPos), solidDirections));
        }
        return validTorchPositions;
    }

    private static int getLightLimit() {
        return Math.min((Integer)LIGHT_LIMIT.get(), 13);
    }

    private static int getLightTarget() {
        return Math.min(Math.max(AutoCaveTorchItem.getLightLimit() + 1, (Integer)LIGHT_TARGET.get()), 14);
    }

    private static boolean isPreferWalls() {
        return (Boolean)PREFER_WALLS.get();
    }

    private static boolean isPreferLeftWall() {
        return (Boolean)PREFER_LEFT_WALL.get();
    }

    private static class TorchPos {
        final BlockPos pos;
        final int relativeHeight;
        final int playerLightLevel;
        final int currentLightLevel;
        final EnumSet<Direction> solidDirections;

        public TorchPos(BlockPos pos, int relativeHeight, int playerLightLevel, int currentLightLevel, EnumSet<Direction> solidDirections) {
            assert (!solidDirections.isEmpty());
            this.pos = pos;
            this.relativeHeight = relativeHeight;
            this.playerLightLevel = playerLightLevel;
            this.currentLightLevel = currentLightLevel;
            this.solidDirections = solidDirections;
        }

        public boolean isNotOnGround() {
            return !this.solidDirections.contains(Direction.DOWN);
        }

        public boolean isNotBelowFeet() {
            return this.relativeHeight >= 0;
        }

        public Direction getPlacementDirection(Direction facing) {
            Direction preferredDirection;
            if (this.solidDirections.contains(Direction.DOWN)) {
                return Direction.DOWN;
            }
            Direction direction = preferredDirection = AutoCaveTorchItem.isPreferLeftWall() ? facing.func_176735_f() : facing.func_176746_e();
            if (this.solidDirections.contains(preferredDirection)) {
                return preferredDirection;
            }
            Direction otherDirection = preferredDirection.func_176734_d();
            if (this.solidDirections.contains(otherDirection)) {
                return otherDirection;
            }
            Direction behindPlayer = facing.func_176734_d();
            if (this.solidDirections.contains(behindPlayer)) {
                return behindPlayer;
            }
            assert (this.solidDirections.contains(facing));
            return facing;
        }
    }
}

