/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.util.UtilChat;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class SpawnInspectorTool
extends ItemBase {
    public SpawnInspectorTool(Item.Properties properties) {
        super(properties);
    }

    private static BlockPos getTopSolidOrLiquidBlock(IWorldReader worldIn, EntityType<?> etype, int x, int z) {
        BlockPos blockpos;
        int i = worldIn.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(etype), x, z);
        BlockPos.Mutable mutable = new BlockPos.Mutable(x, i, z);
        if (worldIn.func_230315_m_().func_236037_d_()) {
            do {
                mutable.func_189536_c(Direction.DOWN);
            } while (!worldIn.func_180495_p((BlockPos)mutable).func_196958_f());
            do {
                mutable.func_189536_c(Direction.DOWN);
            } while (worldIn.func_180495_p((BlockPos)mutable).func_196958_f() && mutable.func_177956_o() > 0);
        }
        if (EntitySpawnPlacementRegistry.func_209344_a(etype) == EntitySpawnPlacementRegistry.PlacementType.ON_GROUND && worldIn.func_180495_p(blockpos = mutable.func_177977_b()).func_196957_g((IBlockReader)worldIn, blockpos, PathType.LAND)) {
            return blockpos;
        }
        return mutable.func_185334_h();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        if (context.func_195999_j().func_184811_cZ().func_185141_a((Item)this)) {
            return ActionResultType.PASS;
        }
        context.func_195999_j().func_184811_cZ().func_185145_a((Item)this, 10);
        for (EntityClassification classif : EntityClassification.values()) {
            List list = context.func_195991_k().func_226691_t_(pos).func_242433_b().func_242559_a(classif);
            for (MobSpawnInfo.Spawners spawnerInfo : list) {
                StringTextComponent str = new StringTextComponent("[" + classif.func_220363_a() + "] ");
                BlockPos top = SpawnInspectorTool.getTopSolidOrLiquidBlock((IWorldReader)world, spawnerInfo.field_242588_c, pos.func_177958_n(), pos.func_177952_p());
                if (spawnerInfo.field_242588_c.func_200720_b() && WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.func_209344_a((EntityType)spawnerInfo.field_242588_c), (IWorldReader)world, (BlockPos)top, (EntityType)spawnerInfo.field_242588_c)) {
                    str.func_230529_a_((ITextComponent)new StringTextComponent(spawnerInfo.field_242588_c.func_212546_e().getString()).func_240699_a_(TextFormatting.BLUE));
                } else {
                    str.func_230529_a_((ITextComponent)new StringTextComponent(spawnerInfo.field_242588_c.func_212546_e().getString()).func_240699_a_(TextFormatting.RED));
                }
                UtilChat.addServerChatMessage(context.func_195999_j(), (IFormattableTextComponent)str);
            }
        }
        context.func_195999_j().func_184609_a(context.func_221531_n());
        return ActionResultType.PASS;
    }
}

