/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Unit;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SleepingMatItem
extends ItemBase {
    public static final String CYCLIC_SLEEPING = "cyclic_sleeping";

    public SleepingMatItem(Item.Properties properties) {
        super(properties.func_200917_a(1).func_200918_c(256));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        ItemStack itemstack = player.func_184586_b(handIn);
        BlockPos pos = player.func_233580_cy_();
        if (!worldIn.func_72935_r()) {
            this.trySleep(player, pos, itemstack).ifLeft(p -> {
                if (p != null) {
                    player.func_146105_b(p.func_221259_a(), true);
                }
            });
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    public Either<PlayerEntity.SleepResult, Unit> trySleep(PlayerEntity player, BlockPos at, ItemStack itemstack) {
        Optional<BlockPos> optAt = Optional.of(at);
        PlayerEntity.SleepResult ret = ForgeEventFactory.onPlayerSleepInBed((PlayerEntity)player, optAt);
        if (ret != null) {
            return Either.left((Object)ret);
        }
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            boolean isoverworld;
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return Either.left((Object)PlayerEntity.SleepResult.OTHER_PROBLEM);
            }
            boolean bl = isoverworld = world.func_234923_W_() == World.field_234918_g_;
            if (!isoverworld) {
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_HERE);
            }
            if (!ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, optAt)) {
                player.func_213369_d(at);
                return Either.left((Object)PlayerEntity.SleepResult.NOT_POSSIBLE_NOW);
            }
            player.func_213342_e(at);
            player.getPersistentData().func_74757_a(CYCLIC_SLEEPING, true);
            ObfuscationReflectionHelper.setPrivateValue(PlayerEntity.class, (Object)player, (Object)0, (String)"field_71076_b");
            if (player.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)player.field_70170_p).func_72854_c();
            }
            UtilItemStack.damageItem((LivingEntity)player, itemstack);
        }
        return Either.right((Object)Unit.INSTANCE);
    }
}

