/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.base.EnchantBase;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;

public class EnchantDisarm
extends EnchantBase {
    private static final double BASE_CHANCE = 0.04;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "disarm";

    public EnchantDisarm(Enchantment.Rarity rarityIn, EnchantmentType typeIn, EquipmentSlotType ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int func_77325_b() {
        return 3;
    }

    public double getChanceToDisarm(int level) {
        return 0.04 + 0.02 * (double)(level - 1);
    }

    public void func_151368_a(LivingEntity user, Entity target, int level) {
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        ArrayList toDisarm = new ArrayList();
        target.func_184214_aD().forEach(itemStack -> {
            if (this.getChanceToDisarm(level) > user.field_70170_p.field_73012_v.nextDouble()) {
                toDisarm.add(itemStack);
            }
        });
        toDisarm.forEach(itemStack -> {
            boolean dropHeld = false;
            if (itemStack.equals(livingTarget.func_184614_ca())) {
                livingTarget.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                dropHeld = true;
            } else if (itemStack.equals(livingTarget.func_184592_cb())) {
                livingTarget.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
                dropHeld = true;
            }
            if (dropHeld) {
                user.field_70170_p.func_217376_c((Entity)new ItemEntity(user.field_70170_p, livingTarget.func_226277_ct_(), livingTarget.func_226278_cu_(), livingTarget.func_226281_cx_(), itemStack));
            }
        });
        super.func_151368_a(user, target, level);
    }
}

