/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundrecord;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.soundrecord.ScreenSoundRecorder;
import com.lothrazar.cyclic.block.soundrecord.TileSoundRecorder;
import com.lothrazar.cyclic.net.PacketRecordSound;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilBlockstates;
import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockSoundRecorder
extends BlockBase {
    public static ForgeConfigSpec.IntValue RADIUS;

    public BlockSoundRecorder(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(1.0f).func_200947_a(SoundType.field_222470_q));
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setHasGui();
    }

    @Override
    public void registerClient() {
        ScreenManager.func_216911_a(ContainerScreenRegistry.SOUND_RECORDER, ScreenSoundRecorder::new);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileSoundRecorder();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
        if (event.getSound() == null || event.getSound().func_147650_b() == null || event.getResultSound() instanceof ITickableSound || clientWorld == null) {
            return;
        }
        ArrayList<BlockPos> blocks = UtilBlockstates.findBlocks((World)clientWorld, new BlockPos(event.getSound().func_147649_g(), event.getSound().func_147654_h(), event.getSound().func_147651_i()), this, (Integer)RADIUS.get());
        for (BlockPos nearby : blocks) {
            String sid = event.getSound().func_147650_b().toString();
            PacketRegistry.INSTANCE.sendToServer((Object)new PacketRecordSound(sid, nearby));
            TileEntity tile = clientWorld.func_175625_s(nearby);
            if (!(tile instanceof TileSoundRecorder)) continue;
            ((TileSoundRecorder)tile).onSoundHeard(sid);
        }
    }
}

