/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.hopperfluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.hopperfluid.BlockFluidHopper;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilFluid;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileFluidHopper
extends TileEntityBase
implements ITickableTileEntity {
    private static final int FLOW = 1000;
    public static final int CAPACITY = 1000;
    public FluidTankBase tank = new FluidTankBase(this, 1000, p -> true);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);

    public TileFluidHopper() {
        super((TileEntityType)TileRegistry.FLUIDHOPPER.get());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public void func_73660_a() {
        if (this.isPowered()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.tryExtract(Direction.UP);
        Direction exportToSide = (Direction)this.func_195044_w().func_177229_b((Property)BlockFluidHopper.FACING);
        if (exportToSide != null && exportToSide != Direction.UP) {
            this.moveFluids(exportToSide, this.field_174879_c.func_177972_a(exportToSide), 1000, (IFluidHandler)this.tank);
        }
    }

    private void tryExtract(Direction extractSide) {
        if (extractSide == null || this.tank == null) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(extractSide);
        Direction incomingSide = extractSide.func_176734_d();
        IFluidHandler stuff = UtilFluid.getTank(this.field_145850_b, target, incomingSide);
        boolean success = false;
        if (stuff != null && (success = UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c, extractSide, stuff, 1000))) {
            return;
        }
        if (!success && this.tank.getSpace() >= 1000) {
            UtilFluid.extractSourceWaterloggedCauldron(this.field_145850_b, target, (IFluidHandler)this.tank);
        }
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        return super.func_189515_b(tag);
    }

    public int getFill() {
        if (this.tank == null || this.tank.getFluidInTank(0).isEmpty()) {
            return 0;
        }
        return this.tank.getFluidInTank(0).getAmount();
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

