/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorfluid;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.generatorfluid.TileGeneratorFluid;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.recipe.FluidTagIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeGeneratorFluid<TileEntityBase>
extends CyclicRecipe {
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private final int ticks;
    private final int rfpertick;
    public final FluidTagIngredient fluidIng;
    public static final SerializeGenerateFluid SERIALGENERATORF = new SerializeGenerateFluid();

    public RecipeGeneratorFluid(ResourceLocation id, FluidTagIngredient in, int ticks, int rfpertick) {
        super(id);
        this.fluidIng = in;
        this.ticks = Math.max(1, ticks);
        this.rfpertick = Math.max(1, rfpertick);
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.fluidIng.getFluidStack();
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileGeneratorFluid tile = (TileGeneratorFluid)inv;
            return CyclicRecipe.matchFluid(tile.getFluid(), this.fluidIng);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.field_193370_a) {
            return current.func_190926_b();
        }
        if (current.func_190926_b()) {
            return ing == Ingredient.field_193370_a;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Override
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.GENERATOR_FLUID;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALGENERATORF;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getRfpertick() {
        return this.rfpertick;
    }

    public int getRfTotal() {
        return this.getRfpertick() * this.getTicks();
    }

    public static class SerializeGenerateFluid
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeGeneratorFluid<? extends TileEntityBase>> {
        SerializeGenerateFluid() {
            this.setRegistryName(new ResourceLocation("cyclic", "generator_fluid"));
        }

        public RecipeGeneratorFluid<? extends TileEntityBase> read(ResourceLocation recipeId, JsonObject json) {
            RecipeGeneratorFluid r = null;
            try {
                FluidTagIngredient fs = CyclicRecipe.parseFluid(json, "fuel");
                JsonObject result = json.get("energy").getAsJsonObject();
                int ticks = result.get("ticks").getAsInt();
                int rfpertick = result.get("rfpertick").getAsInt();
                r = new RecipeGeneratorFluid(recipeId, fs, ticks, rfpertick);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe" + recipeId, e);
            }
            ModCyclic.LOGGER.info("Recipe loaded " + r);
            return r;
        }

        public RecipeGeneratorFluid read(ResourceLocation recipeId, PacketBuffer buffer) {
            RecipeGeneratorFluid r = new RecipeGeneratorFluid(recipeId, FluidTagIngredient.readFromPacket(buffer), buffer.readInt(), buffer.readInt());
            return r;
        }

        public void write(PacketBuffer buffer, RecipeGeneratorFluid recipe) {
            recipe.fluidIng.writeToPacket(buffer);
            buffer.writeInt(recipe.getTicks());
            buffer.writeInt(recipe.rfpertick);
        }
    }
}

