/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.net.PacketTileInventoryToClient;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilEnchant;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.items.ItemStackHandler;

public class EnderShelfItemHandler
extends ItemStackHandler {
    public static ForgeConfigSpec.IntValue BOOKS_PER_ROW;
    public static final int ROWS = 5;
    public TileEnderShelf shelf;
    String[] nameCache = new String[5];
    String[] enchantmentIdCache = new String[5];
    int[] extraBooks = new int[5];

    public void resetNameCache() {
        this.nameCache = new String[5];
    }

    public EnderShelfItemHandler(TileEnderShelf shelf) {
        super(5);
        this.shelf = shelf;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = super.serializeNBT();
        for (int i = 0; i < 5; ++i) {
            tag.func_74768_a("cyclicmagic:idc" + i, this.extraBooks[i]);
            if (this.enchantmentIdCache[i] == null) {
                this.enchantmentIdCache[i] = "";
            }
            tag.func_74778_a("cyclicmagic:ench", this.enchantmentIdCache[i]);
        }
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        for (int i = 0; i < 5; ++i) {
            this.extraBooks[i] = nbt.func_74762_e("cyclicmagic:idc" + i);
            this.enchantmentIdCache[i] = nbt.func_74779_i("cyclicmagic:ench");
        }
    }

    public ItemStack emptySlot(int slot) {
        ItemStack returnStack = this.getStackInSlot(slot);
        this.stacks.set(slot, (Object)ItemStack.field_190927_a);
        return returnStack;
    }

    public int getStackLimit(int slot, ItemStack stack) {
        return (Integer)BOOKS_PER_ROW.get();
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.shelf.func_145831_w() == null) {
            return ItemStack.field_190927_a;
        }
        boolean oldEmpty = ((ItemStack)this.stacks.get(slot)).func_190926_b();
        ItemStack extracted = super.extractItem(slot, amount, simulate);
        boolean newEmpty = ((ItemStack)this.stacks.get(slot)).func_190926_b();
        if (oldEmpty != newEmpty) {
            this.refreshId(slot);
        }
        if (!simulate) {
            PacketRegistry.sendToAllClients(this.shelf.func_145831_w(), new PacketTileInventoryToClient(this.shelf.func_174877_v(), slot, this.getStackInSlot(slot), PacketTileInventoryToClient.SyncPacketType.SET));
        }
        if (this.shelf.func_145831_w().field_72995_K && oldEmpty != ((ItemStack)this.stacks.get(slot)).func_190926_b()) {
            this.nameCache[slot] = "";
        }
        return extracted;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        boolean oldEmpty = ((ItemStack)this.stacks.get(slot)).func_190926_b();
        ItemStack remaining = super.insertItem(slot, stack, simulate);
        boolean newEmpty = ((ItemStack)this.stacks.get(slot)).func_190926_b();
        if (oldEmpty != newEmpty) {
            this.refreshId(slot);
        }
        if (!simulate) {
            PacketRegistry.sendToAllClients(this.shelf.func_145831_w(), new PacketTileInventoryToClient(this.shelf.func_174877_v(), slot, this.getStackInSlot(slot), PacketTileInventoryToClient.SyncPacketType.SET));
        }
        return remaining;
    }

    private void refreshId(int slot) {
        block1: {
            ItemStack stackIn;
            block0: {
                stackIn = this.getStackInSlot(slot);
                if (!stackIn.func_190926_b()) break block0;
                this.enchantmentIdCache[slot] = "";
                break block1;
            }
            ListNBT chantsIn = EnchantedBookItem.func_92110_g((ItemStack)stackIn);
            this.enchantmentIdCache[slot] = ((CompoundNBT)chantsIn.get(0)).func_74779_i("id");
            Map enchantments = EnchantmentHelper.func_226652_a_((ListNBT)chantsIn);
            Iterator iterator = enchantments.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            Map.Entry entry = iterator.next();
            this.nameCache[slot] = ((Enchantment)entry.getKey()).func_200305_d(((Integer)entry.getValue()).intValue()).getString();
        }
    }

    public boolean isItemValid(int slot, ItemStack stackIn) {
        if (stackIn.func_77973_b() != Items.field_151134_bR) {
            return false;
        }
        ListNBT chantsIn = EnchantedBookItem.func_92110_g((ItemStack)stackIn);
        if (chantsIn.size() != 1) {
            return false;
        }
        boolean oldEmpty = this.getStackInSlot(slot).func_190926_b();
        if (oldEmpty) {
            return true;
        }
        ItemStack stackHere = this.getStackInSlot(slot);
        if (this.enchantmentIdCache[slot] != null || !this.enchantmentIdCache[slot].isEmpty()) {
            boolean match = this.enchantmentIdCache[slot].equals(((CompoundNBT)chantsIn.get(0)).func_74779_i("id"));
            return match;
        }
        return UtilEnchant.doBookEnchantmentsMatch(stackIn, stackHere);
    }

    public boolean isEmptyShelves() {
        int empty = 0;
        for (int i = 0; i < 5; ++i) {
            if (this.enchantmentIdCache[i] != null && !this.enchantmentIdCache[i].isEmpty()) continue;
            ++empty;
        }
        return empty == 5;
    }
}

