/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.bedrock;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.util.UtilParticle;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class UnbreakableBlock
extends BlockBase {
    public static final BooleanProperty BREAKABLE = BooleanProperty.func_177716_a((String)"breakable");

    public UnbreakableBlock(AbstractBlock.Properties properties) {
        super(properties.func_200948_a(50.0f, 1200.0f));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItemStack = player.func_184586_b(hand);
        Item heldItem = heldItemStack.func_77973_b();
        if (state.func_235901_b_((Property)BREAKABLE) && hand == Hand.MAIN_HAND && heldItem == Items.field_151137_ax || heldItem == Items.field_221764_cr || heldItem == Items.field_221858_em) {
            this.toggle(state, world, pos);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    private void toggle(BlockState state, World world, BlockPos pos) {
        this.setBreakable(state, world, pos, (Boolean)state.func_177229_b((Property)BREAKABLE) == false);
    }

    private void setBreakable(BlockState state, World world, BlockPos pos, boolean isBreakable) {
        boolean oldBreakable = (Boolean)state.func_177229_b((Property)BREAKABLE);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BREAKABLE, (Comparable)Boolean.valueOf(isBreakable)));
        if (world.field_72995_K && oldBreakable != isBreakable) {
            UtilParticle.spawnParticle(world, (IParticleData)RedstoneParticleData.field_197564_a, pos, 5);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockState neighborState = worldIn.func_180495_p(fromPos);
        if (!isMoving && neighborState.func_235901_b_((Property)BREAKABLE) && state.func_235901_b_((Property)BREAKABLE)) {
            this.setBreakable(state, worldIn, pos, (Boolean)neighborState.func_177229_b((Property)BREAKABLE));
        }
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        return state.func_235901_b_((Property)BREAKABLE) && (Boolean)state.func_177229_b((Property)BREAKABLE) == false ? 0.0f : super.func_180647_a(state, player, worldIn, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BREAKABLE});
    }
}

