/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouselytra;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import top.theillusivec4.caelus.api.CaelusApi;
import top.theillusivec4.caelus.api.RenderElytraEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curiouselytra.CurioElytra;
import top.theillusivec4.curiouselytra.integration.AetherCape;
import top.theillusivec4.curiouselytra.integration.EnderiteElytra;
import top.theillusivec4.curiouselytra.integration.ICustomElytra;
import top.theillusivec4.curiouselytra.integration.NetheritePlusElytra;
import top.theillusivec4.curiouselytra.integration.SilentGearElytra;
import top.theillusivec4.curiouselytra.integration.SpectralElytra;

@Mod(value="curiouselytra")
public class CuriousElytra {
    public static final String MOD_ID = "curiouselytra";
    private static final Map<String, Supplier<Supplier<ICustomElytra>>> INTEGRATIONS = new HashMap<String, Supplier<Supplier<ICustomElytra>>>();
    private static final List<ICustomElytra> ACTIVE_INTEGRATIONS = new ArrayList<ICustomElytra>();

    public CuriousElytra() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::setup);
        ModList modList = ModList.get();
        for (Map.Entry<String, Supplier<Supplier<ICustomElytra>>> entry : INTEGRATIONS.entrySet()) {
            if (!modList.isLoaded(entry.getKey())) continue;
            ACTIVE_INTEGRATIONS.add(entry.getValue().get().get());
        }
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
        MinecraftForge.EVENT_BUS.addListener(this::playerTick);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addListener(this::renderElytra);
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    private void playerTick(TickEvent.PlayerTickEvent evt) {
        PlayerEntity player = evt.player;
        ModifiableAttributeInstance attributeInstance = player.func_110148_a((Attribute)CaelusApi.ELYTRA_FLIGHT.get());
        if (attributeInstance != null) {
            attributeInstance.func_111124_b(CurioElytra.ELYTRA_CURIO_MODIFIER);
            if (!attributeInstance.func_180374_a(CurioElytra.ELYTRA_CURIO_MODIFIER)) {
                CuriosApi.getCuriosHelper().findEquippedCurio(stack -> CaelusApi.canElytraFly((LivingEntity)player, (ItemStack)stack), (LivingEntity)player).ifPresent(triple -> attributeInstance.func_233767_b_(CurioElytra.ELYTRA_CURIO_MODIFIER));
            }
        }
    }

    private void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        boolean attachable = stack.func_77973_b() instanceof ElytraItem;
        if (!attachable) {
            for (ICustomElytra module : ACTIVE_INTEGRATIONS) {
                if (!module.attachCapability(stack)) continue;
                attachable = true;
                break;
            }
        }
        if (attachable) {
            final LazyOptional elytraCurio = LazyOptional.of(() -> new CurioElytra(stack));
            evt.addCapability(CuriosCapability.ID_ITEM, new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, elytraCurio);
                }
            });
            evt.addListener(() -> ((LazyOptional)elytraCurio).invalidate());
        }
    }

    private void renderElytra(RenderElytraEvent evt) {
        PlayerEntity playerEntity = evt.getPlayer();
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)playerEntity).ifPresent(handler -> {
            Set tags = CuriosApi.getCuriosHelper().getCurioTags(Items.field_185160_cR);
            for (String id : tags) {
                handler.getStacksHandler(id).ifPresent(stacksHandler -> {
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (!((Boolean)stacksHandler.getRenders().get(i)).booleanValue()) continue;
                        boolean isElytra = CaelusApi.isElytra((ItemStack)stack);
                        for (ICustomElytra module : ACTIVE_INTEGRATIONS) {
                            if (!module.renderElytra(stack, evt)) continue;
                            isElytra = true;
                            break;
                        }
                        if (!isElytra) continue;
                        evt.setRender(true);
                        if (stack.func_77948_v()) {
                            evt.setEnchanted(true);
                        }
                        return;
                    }
                });
            }
        });
    }

    static {
        INTEGRATIONS.put("aether", () -> AetherCape::new);
        INTEGRATIONS.put("silentgear", () -> SilentGearElytra::new);
        INTEGRATIONS.put("netherite_plus", () -> NetheritePlusElytra::new);
        INTEGRATIONS.put("mana-and-artifice", () -> SpectralElytra::new);
        INTEGRATIONS.put("enderitemod", () -> EnderiteElytra::new);
    }
}

