/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.server.sync;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class SPacketSyncStack {
    private int entityId;
    private int slotId;
    private String curioId;
    private ItemStack stack;
    private int handlerType;
    private CompoundNBT compound;

    public SPacketSyncStack(int entityId, String curioId, int slotId, ItemStack stack, HandlerType handlerType, CompoundNBT data) {
        this.entityId = entityId;
        this.slotId = slotId;
        this.stack = stack.func_77946_l();
        this.curioId = curioId;
        this.handlerType = handlerType.ordinal();
        this.compound = data;
    }

    public static void encode(SPacketSyncStack msg, PacketBuffer buf) {
        buf.writeInt(msg.entityId);
        buf.func_180714_a(msg.curioId);
        buf.writeInt(msg.slotId);
        buf.func_150788_a(msg.stack);
        buf.writeInt(msg.handlerType);
        buf.func_150786_a(msg.compound);
    }

    public static SPacketSyncStack decode(PacketBuffer buf) {
        return new SPacketSyncStack(buf.readInt(), buf.func_150789_c(25), buf.readInt(), buf.func_150791_c(), HandlerType.fromValue(buf.readInt()), buf.func_150793_b());
    }

    public static void handle(SPacketSyncStack msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(msg.entityId)) instanceof LivingEntity) {
                CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)entity).ifPresent(handler -> handler.getStacksHandler(msg.curioId).ifPresent(stacksHandler -> {
                    ItemStack stack = msg.stack;
                    CompoundNBT compoundNBT = msg.compound;
                    int slot = msg.slotId;
                    if (!compoundNBT.isEmpty()) {
                        CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.readSyncData(compoundNBT));
                    }
                    if (HandlerType.fromValue(msg.handlerType) == HandlerType.COSMETIC) {
                        stacksHandler.getCosmeticStacks().setStackInSlot(slot, stack);
                    } else {
                        stacksHandler.getStacks().setStackInSlot(slot, stack);
                    }
                }));
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum HandlerType {
        EQUIPMENT,
        COSMETIC;


        public static HandlerType fromValue(int value) {
            try {
                return HandlerType.values()[value];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Unknown handler value: " + value);
            }
        }
    }
}

