/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.culinaryconstruct.common.capability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.CakeBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MilkBucketItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.culinaryconstruct.api.capability.CulinaryConstructCapability;
import top.theillusivec4.culinaryconstruct.api.capability.ICulinaryIngredient;
import top.theillusivec4.culinaryconstruct.common.capability.CapabilityCulinaryFood;

public class CapabilityEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        final ItemStack stack = (ItemStack)evt.getObject();
        final Item item = stack.func_77973_b();
        if (item instanceof BlockItem && ((BlockItem)item).func_179223_d() instanceof CakeBlock) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public int getFoodAmount() {
                    return 14;
                }

                @Override
                public float getSaturation() {
                    return 0.2f;
                }
            }));
        } else if (item instanceof BucketItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public boolean isValid() {
                    Fluid fluid = ((BucketItem)item).getFluid();
                    if (fluid == Fluids.field_204541_a) {
                        return false;
                    }
                    FluidAttributes attributes = fluid.getAttributes();
                    return !attributes.isGaseous() && !attributes.isLighterThanAir() && attributes.getTemperature() <= 400;
                }

                @Override
                public boolean isLiquid() {
                    return true;
                }

                @Override
                public Integer getLiquidColor() {
                    Fluid fluid = ((BucketItem)item).getFluid();
                    if (fluid == Fluids.field_204546_a) {
                        return null;
                    }
                    FluidAttributes attributes = fluid.getAttributes();
                    return attributes.getColor();
                }
            }));
        } else if (item instanceof MilkBucketItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public void onEaten(PlayerEntity player) {
                    if (!player.field_70170_p.field_72995_K) {
                        player.curePotionEffects(stack);
                    }
                }

                @Override
                public boolean isLiquid() {
                    return true;
                }

                @Override
                public Integer getLiquidColor() {
                    return 0xFFFFFF;
                }
            }));
        } else if (item instanceof PotionItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public List<Pair<EffectInstance, Float>> getEffects() {
                    ArrayList<Pair<EffectInstance, Float>> list = new ArrayList<Pair<EffectInstance, Float>>();
                    PotionUtils.func_185189_a((ItemStack)stack).forEach(effect -> list.add(Pair.of((Object)new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c()), (Object)Float.valueOf(1.0f))));
                    return list;
                }

                @Override
                public boolean isLiquid() {
                    return true;
                }

                @Override
                public Integer getLiquidColor() {
                    return PotionUtils.func_190932_c((ItemStack)stack);
                }
            }));
        } else if (item instanceof SuspiciousStewItem) {
            evt.addCapability(CulinaryConstructCapability.INGREDIENT_ID, CapabilityCulinaryFood.createCulinaryIngredient(new ICulinaryIngredient(){

                @Override
                public List<Pair<EffectInstance, Float>> getEffects() {
                    ArrayList<Pair<EffectInstance, Float>> list = new ArrayList<Pair<EffectInstance, Float>>();
                    CompoundNBT compoundnbt = stack.func_77978_p();
                    if (compoundnbt != null && compoundnbt.func_150297_b("Effects", 9)) {
                        ListNBT listnbt = compoundnbt.func_150295_c("Effects", 10);
                        for (int i = 0; i < listnbt.size(); ++i) {
                            Effect effect;
                            int j = 160;
                            CompoundNBT compoundnbt1 = listnbt.func_150305_b(i);
                            if (compoundnbt1.func_150297_b("EffectDuration", 3)) {
                                j = compoundnbt1.func_74762_e("EffectDuration");
                            }
                            if ((effect = Effect.func_188412_a((int)compoundnbt1.func_74771_c("EffectId"))) == null) continue;
                            list.add((Pair<EffectInstance, Float>)Pair.of((Object)new EffectInstance(effect, j), (Object)Float.valueOf(1.0f)));
                        }
                    }
                    return list;
                }
            }));
        }
    }
}

