/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.event.ScytheHarvestCropEvent;
import com.blakebr0.cucumber.iface.IEnableable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseScytheItem
extends SwordItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Method GET_SEED = ObfuscationReflectionHelper.findMethod(CropsBlock.class, (String)"func_199772_f", (Class[])new Class[0]);
    private final float attackDamage;
    private final float attackSpeed;
    private final int range;

    public BaseScytheItem(IItemTier tier, int attackDamage, float attackSpeed, int range, Function<Item.Properties, Item.Properties> properties) {
        super(tier, attackDamage, attackSpeed, properties.apply(new Item.Properties()));
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.range = range;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this instanceof IEnableable) {
            IEnableable enableable = (IEnableable)((Object)this);
            if (enableable.isEnabled()) {
                super.func_150895_a(group, items);
            }
        } else {
            super.func_150895_a(group, items);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        Direction face = context.func_196000_l();
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(face), face, stack)) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        if (world.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        int range = this.range;
        BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-range, 0, -range), (BlockPos)pos.func_177982_a(range, 0, range)).forEach(aoePos -> {
            if (stack.func_190926_b()) {
                return;
            }
            BlockState state = world.func_180495_p(aoePos);
            ScytheHarvestCropEvent event = new ScytheHarvestCropEvent((IWorld)world, (BlockPos)aoePos, state, stack, player);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            Block block = state.func_177230_c();
            if (block instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)block;
                Item seed = BaseScytheItem.getSeed((Block)crop);
                if (crop.func_185525_y(state) && seed != null) {
                    List drops = Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)aoePos, (TileEntity)world.func_175625_s(aoePos));
                    for (ItemStack drop : drops) {
                        Item item = drop.func_77973_b();
                        if (drop.func_190926_b() || item != seed) continue;
                        drop.func_190918_g(1);
                        break;
                    }
                    for (ItemStack drop : drops) {
                        if (drop.func_190926_b()) continue;
                        Block.func_180635_a((World)world, (BlockPos)aoePos, (ItemStack)drop);
                    }
                    stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(player.func_184600_cs()));
                    world.func_175656_a(aoePos, crop.func_185528_e(0));
                }
            }
        });
        return ActionResultType.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (player.func_184825_o(0.5f) >= 0.95f) {
            World world = player.field_70170_p;
            double range = this.range >= 2 ? 1.0 + (double)(this.range - 1) * 0.25 : 1.0;
            List entities = world.func_217357_a(LivingEntity.class, entity.func_174813_aQ().func_72314_b(range, 0.25, range));
            for (LivingEntity aoeEntity : entities) {
                float attackDamage;
                DamageSource source;
                boolean success;
                if (aoeEntity == player || aoeEntity == entity || player.func_184191_r(entity) || !(success = ForgeHooks.onLivingAttack((LivingEntity)aoeEntity, (DamageSource)(source = DamageSource.func_76365_a((PlayerEntity)player)), (float)(attackDamage = this.getAttackDamage() * 0.67f)))) continue;
                aoeEntity.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                aoeEntity.func_70097_a(source, attackDamage);
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
            player.func_184810_cG();
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public float getAttackDamage() {
        return this.attackDamage + this.func_200891_e().func_200929_c();
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    private static Item getSeed(Block block) {
        try {
            return (Item)GET_SEED.invoke((Object)block, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Unable to get seed from crop {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }
}

