/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CentrifugeTiers.tileentity;

import com.YTrollman.CentrifugeTiers.block.CentrifugeCasingBlockTierCreative;
import com.YTrollman.CentrifugeTiers.block.CentrifugeControllerBlockTierCreative;
import com.YTrollman.CentrifugeTiers.config.CentrifugeConfig;
import com.YTrollman.CentrifugeTiers.container.CentrifugeMultiblockContainerTierCreative;
import com.YTrollman.CentrifugeTiers.registry.ModContainers;
import com.YTrollman.CentrifugeTiers.tileentity.CentrifugeCasingTileEntityTierCreative;
import com.resourcefulbees.resourcefulbees.capabilities.CustomEnergyStorage;
import com.resourcefulbees.resourcefulbees.recipe.CentrifugeRecipe;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.MultiBlockHelper;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.centrifuge.CentrifugeControllerTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CentrifugeControllerTileEntityTierCreative
extends CentrifugeControllerTileEntity {
    public int ItemMaxStackSize = (Integer)CentrifugeConfig.CENTRIFUGE_TIER_CREATIVE_ITEM_MAX_STACK_SIZE.get();
    private final IntArray times = new IntArray(9){

        public int func_221476_a(int index) {
            if (this.func_221478_a() - index >= 1) {
                return CentrifugeControllerTileEntityTierCreative.this.time[index];
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            if (this.func_221478_a() - index >= 1) {
                ((CentrifugeControllerTileEntityTierCreative)CentrifugeControllerTileEntityTierCreative.this).time[index] = value;
            }
        }

        public int func_221478_a() {
            return 9;
        }
    };
    private final List<String> blacklist = (List)CentrifugeConfig.CENTRIFUGE_MULTIPLIER_BLACKLIST.get();
    private final int multiplier = (Integer)CentrifugeConfig.CENTRIFUGE_TIER_CREATIVE_MUTLIPLIER.get();

    public CentrifugeControllerTileEntityTierCreative(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public void checkHoneycombSlots() {
        for (int i = 0; i < this.honeycombSlots.length; ++i) {
            this.recipes.set(i, this.getRecipe(i));
            if (this.canStartCentrifugeProcess(i)) {
                this.isProcessing[i] = true;
            }
            if (this.isProcessing[i] && !this.processCompleted[i]) {
                this.processRecipe(i);
            }
            if (!this.processCompleted[i]) continue;
            this.completeProcess(i);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            if (this.isValidStructure() && (!this.requiresRedstone || this.isPoweredByRedstone)) {
                this.checkHoneycombSlots();
            }
            ++this.validateTime;
            if (this.validateTime >= 0) {
                this.validateStructure(this.field_145850_b);
            }
            if (this.dirty) {
                this.dirty = false;
                this.func_70296_d();
            }
        }
    }

    protected void completeProcess(int i) {
        if (this.recipes.get(i) == null) {
            this.resetProcess(i);
        } else if (this.inventoryHasSpace((CentrifugeRecipe)this.recipes.get(i)) && this.tanksHasSpace((CentrifugeRecipe)this.recipes.get(i))) {
            ItemStack centrifugeInput = this.itemStackHandler.getStackInSlot(this.honeycombSlots[i]);
            ItemStack glassBottle = this.itemStackHandler.getStackInSlot(0);
            ArrayList<ItemStack> depositStacks = new ArrayList<ItemStack>();
            if (this.field_145850_b != null) {
                CentrifugeRecipe recipe = (CentrifugeRecipe)this.recipes.get(i);
                for (int j = 0; j < recipe.itemOutputs.size(); ++j) {
                    float chance = ((Float)((Pair)recipe.itemOutputs.get(j)).getRight()).floatValue();
                    if (!(chance >= this.field_145850_b.field_73012_v.nextFloat())) continue;
                    ItemStack output = ((ItemStack)((Pair)recipe.itemOutputs.get(j)).getLeft()).func_77946_l();
                    output.func_190920_e(output.func_190916_E() * (this.blacklist.contains(centrifugeInput.func_77973_b().getRegistryName().toString()) ? 1 : this.multiplier));
                    depositStacks.add(output);
                    if (j != 2 || recipe.noBottleInput) continue;
                    glassBottle.func_190918_g(((ItemStack)((Pair)((CentrifugeRecipe)this.recipes.get((int)i)).itemOutputs.get(2)).getLeft()).func_190916_E() * this.multiplier);
                }
                for (Pair fluidStackFloatPair : recipe.fluidOutput) {
                    float chance = ((Float)fluidStackFloatPair.getRight()).floatValue();
                    if (!(chance >= this.field_145850_b.field_73012_v.nextFloat())) continue;
                    FluidStack fluid = ((FluidStack)fluidStackFloatPair.getLeft()).copy();
                    int tank = this.getValidTank(fluid);
                    if (fluid.getAmount() != 0) {
                        fluid.setAmount(fluid.getAmount() * (this.blacklist.contains(centrifugeInput.func_77973_b().getRegistryName().toString()) ? 1 : this.multiplier));
                    }
                    if (tank == -1) continue;
                    this.fluidTanks.fill(tank, fluid, IFluidHandler.FluidAction.EXECUTE);
                }
                if (!depositStacks.isEmpty()) {
                    this.depositItemStacks(depositStacks);
                }
            }
            this.consumeInput(i);
            this.resetProcess(i);
        }
    }

    private boolean tanksHasSpace(CentrifugeRecipe centrifugeRecipe) {
        if (centrifugeRecipe == null) {
            return false;
        }
        for (Pair f : centrifugeRecipe.fluidOutput) {
            if (((FluidStack)f.getLeft()).isEmpty()) continue;
            return this.getValidTank((FluidStack)f.getKey()) >= 0;
        }
        return true;
    }

    private int getValidTank(FluidStack fluid) {
        for (int i = 0; i < this.fluidTanks.getTanks(); ++i) {
            if (this.fluidTanks.getFluidInTank(i).getFluid() != fluid.getFluid() && !this.fluidTanks.getFluidInTank(i).isEmpty()) continue;
            return this.fluidTanks.getFluidInTank(i).getAmount() + fluid.getAmount() <= this.fluidTanks.getTankCapacity(i) ? i : -1;
        }
        return -1;
    }

    protected void processRecipe(int i) {
        if (this.canProcess(i)) {
            int n = i;
            this.time[n] = this.time[n] + 1;
            this.processCompleted[i] = this.time[i] >= this.getRecipeTime(i);
            this.dirty = true;
        } else {
            this.resetProcess(i);
        }
    }

    protected boolean canProcess(int i) {
        return !this.itemStackHandler.getStackInSlot(this.honeycombSlots[i]).func_190926_b() && this.canProcessFluid(i) && this.canProcessEnergy();
    }

    protected boolean canProcessEnergy() {
        return true;
    }

    protected void depositItemStacks(List<ItemStack> itemStacks) {
        itemStacks.forEach(itemStack -> {
            for (int slotIndex = this.outputSlots[0]; !itemStack.func_190926_b() && slotIndex < this.itemStackHandler.getSlots(); ++slotIndex) {
                ItemStack slotStack = this.itemStackHandler.getStackInSlot(slotIndex);
                int itemMaxStackSize = this.ItemMaxStackSize;
                if (slotStack.func_190926_b()) {
                    this.itemStackHandler.setStackInSlot(slotIndex, itemStack.func_77979_a(itemMaxStackSize));
                    continue;
                }
                if (!Container.func_195929_a((ItemStack)itemStack, (ItemStack)slotStack) || slotStack.func_190916_E() == itemMaxStackSize) continue;
                int combinedCount = itemStack.func_190916_E() + slotStack.func_190916_E();
                if (combinedCount <= itemMaxStackSize) {
                    itemStack.func_190920_e(0);
                    slotStack.func_190920_e(combinedCount);
                } else {
                    itemStack.func_190918_g(itemMaxStackSize - slotStack.func_190916_E());
                    slotStack.func_190920_e(itemMaxStackSize);
                }
                this.itemStackHandler.setStackInSlot(slotIndex, slotStack);
            }
        });
    }

    protected boolean inventoryHasSpace(CentrifugeRecipe recipe) {
        int emptySlots = 0;
        for (int i = this.outputSlots[0]; i < this.itemStackHandler.getSlots(); ++i) {
            if (!this.itemStackHandler.getStackInSlot(i).func_190926_b()) continue;
            ++emptySlots;
        }
        boolean hasSpace = true;
        for (int i = 0; recipe != null && hasSpace && i < recipe.itemOutputs.size(); ++i) {
            ItemStack output = (ItemStack)((Pair)recipe.itemOutputs.get(i)).getLeft();
            if (output.func_190926_b() || i == 2 && this.itemStackHandler.getStackInSlot(0).func_190926_b()) continue;
            int count = output.func_190916_E();
            for (int j = this.outputSlots[0]; count > 0 && j < this.itemStackHandler.getSlots(); ++j) {
                ItemStack slotStack = this.itemStackHandler.getStackInSlot(j);
                if (slotStack.func_190926_b() && emptySlots != 0) {
                    count -= Math.min(count, this.ItemMaxStackSize);
                    --emptySlots;
                    continue;
                }
                if (!Container.func_195929_a((ItemStack)output, (ItemStack)slotStack) || slotStack.func_190916_E() == this.ItemMaxStackSize) continue;
                count -= Math.min(count, this.ItemMaxStackSize - slotStack.func_190916_E());
            }
            hasSpace = count <= 0;
        }
        return hasSpace;
    }

    public int getNumberOfInputs() {
        return 9;
    }

    public int getMaxTankCapacity() {
        return (Integer)CentrifugeConfig.CENTRIFUGE_TIER_CREATIVE_MAX_TANK_CAPACITY.get();
    }

    public int getRecipeTime(int i) {
        return (Integer)CentrifugeConfig.CENTRIFUGE_TIER_CREATIVE_RECIPE_TIME.get();
    }

    protected CustomEnergyStorage createEnergy() {
        return new CustomEnergyStorage(1, 0, 0){

            protected void onEnergyChanged() {
                CentrifugeControllerTileEntityTierCreative.this.func_70296_d();
            }
        };
    }

    protected MutableBoundingBox getBounds() {
        if (((Boolean)CentrifugeConfig.CENTRIFUGE_TIER_CREATIVE_SIZE.get()).booleanValue()) {
            return MultiBlockHelper.buildStructureBounds((BlockPos)this.func_174877_v(), (int)3, (int)3, (int)3, (int)-1, (int)-1, (int)-2, (Direction)((Direction)this.func_195044_w().func_177229_b((Property)CentrifugeControllerBlockTierCreative.FACING)));
        }
        if (!((Boolean)CentrifugeConfig.CENTRIFUGE_TIER_CREATIVE_SIZE.get()).booleanValue()) {
            return MultiBlockHelper.buildStructureBounds((BlockPos)this.func_174877_v(), (int)3, (int)4, (int)3, (int)-1, (int)-1, (int)-2, (Direction)((Direction)this.func_195044_w().func_177229_b((Property)CentrifugeControllerBlockTierCreative.FACING)));
        }
        return MultiBlockHelper.buildStructureBounds((BlockPos)this.func_174877_v(), (int)3, (int)3, (int)3, (int)-1, (int)-1, (int)-2, (Direction)((Direction)this.func_195044_w().func_177229_b((Property)CentrifugeControllerBlockTierCreative.FACING)));
    }

    protected void validateStructure(World world) {
        this.validateTime = 0;
        MultiBlockHelper.buildStructureList((MutableBoundingBox)this.getBounds(), (List)this.structureBlocks, blockPos -> true, (BlockPos)this.func_174877_v());
        this.validStructure = (Boolean)CentrifugeConfig.CENTRIFUGE_TIER_CREATIVE_SIZE.get() != false ? MultiBlockHelper.validateStructure((List)this.structureBlocks, this.validBlocks(), (int)26) : MultiBlockHelper.validateStructure((List)this.structureBlocks, this.validBlocks(), (int)35);
        world.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CentrifugeControllerBlockTierCreative.PROPERTY_VALID, (Comparable)Boolean.valueOf(this.validStructure)));
        if (this.validStructure) {
            this.linkCasings(world);
        }
    }

    protected void linkCasings(World world) {
        if (!world.field_72995_K) {
            this.structureBlocks.stream().map(arg_0 -> ((World)world).func_175625_s(arg_0)).filter(CentrifugeCasingTileEntityTierCreative.class::isInstance).forEach(tileEntity -> ((CentrifugeCasingTileEntityTierCreative)((Object)tileEntity)).setControllerPos(this.field_174879_c));
        }
    }

    protected void unlinkCasings(World world) {
        if (!world.field_72995_K) {
            this.structureBlocks.stream().map(arg_0 -> ((World)world).func_175625_s(arg_0)).filter(CentrifugeCasingTileEntityTierCreative.class::isInstance).forEach(tileEntity -> ((CentrifugeCasingTileEntityTierCreative)((Object)tileEntity)).setControllerPos(null));
        }
    }

    protected Predicate<BlockPos> validBlocks() {
        return blockPos -> {
            assert (this.field_145850_b != null) : "Validating Centrifuge - How is world null??";
            Block block = this.field_145850_b.func_180495_p(blockPos).func_177230_c();
            TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
            if (block instanceof CentrifugeCasingBlockTierCreative && tileEntity instanceof CentrifugeCasingTileEntityTierCreative) {
                CentrifugeCasingTileEntityTierCreative casing = (CentrifugeCasingTileEntityTierCreative)tileEntity;
                return !casing.isLinked() || casing.getController() != null && casing.getController().equals((Object)this);
            }
            return false;
        };
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity playerEntity) {
        assert (this.field_145850_b != null);
        return new CentrifugeMultiblockContainerTierCreative((ContainerType)ModContainers.CENTRIFUGE_MULTIBLOCK_CONTAINER_TIER_CREATIVE.get(), id, this.field_145850_b, this.field_174879_c, playerInventory, this.times);
    }
}

