/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeWirelessTransmitter.setup;

import com.YTrollman.CreativeWirelessTransmitter.gui.screen.CreativeWirelessTransmitterScreen;
import com.YTrollman.CreativeWirelessTransmitter.registry.ModBlocks;
import com.YTrollman.CreativeWirelessTransmitter.registry.ModContainers;
import com.refinedmods.refinedstorage.render.BakedModelOverrideRegistry;
import com.refinedmods.refinedstorage.render.model.FullbrightBakedModel;
import com.refinedmods.refinedstorage.util.ColorMap;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientSetup {
    private final BakedModelOverrideRegistry bakedModelOverrideRegistry = new BakedModelOverrideRegistry();

    public ClientSetup() {
        this.forEachColorApply("creative_wireless_transmitter", (name, color) -> this.bakedModelOverrideRegistry.add(name, (base, registry) -> new FullbrightBakedModel(base, true, new ResourceLocation[]{this.getColoredModel((DyeColor)color, "block/creative_wireless_transmitter/cutouts/")})));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    private ResourceLocation getColoredModel(DyeColor color, String path) {
        return new ResourceLocation("creativewirelesstransmitter", path + color);
    }

    private void forEachColorApply(String name, BiConsumer<ResourceLocation, DyeColor> consumer) {
        for (DyeColor color : DyeColor.values()) {
            String prefix = color == ColorMap.DEFAULT_COLOR ? "" : color + "_";
            consumer.accept(new ResourceLocation("creativewirelesstransmitter", prefix + name), color);
        }
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent e) {
        ScreenManager.func_216911_a(ModContainers.CREATIVE_WIRELESS_TRANSMITTER, CreativeWirelessTransmitterScreen::new);
        ModBlocks.CREATIVE_WIRELESS_TRANSMITTER.values().forEach(block -> RenderTypeLookup.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.func_228643_e_()));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        FullbrightBakedModel.invalidateCache();
        for (ResourceLocation id : e.getModelRegistry().keySet()) {
            BakedModelOverrideRegistry.BakedModelOverrideFactory factory = this.bakedModelOverrideRegistry.get(new ResourceLocation(id.func_110624_b(), id.func_110623_a()));
            if (factory == null) continue;
            e.getModelRegistry().put(id, factory.create((IBakedModel)e.getModelRegistry().get(id), e.getModelRegistry()));
        }
    }
}

