/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeCrafter.node;

import com.YTrollman.CreativeCrafter.config.CreativeCrafterConfig;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPattern;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.refinedmods.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.PatternItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CreativeCrafterNetworkNode
extends NetworkNode
implements ICraftingPatternContainer {
    private static final String NBT_DISPLAY_NAME = "DisplayName";
    private static final String NBT_UUID = "CrafterUuid";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_LOCKED = "Locked";
    private static final String NBT_WAS_POWERED = "WasPowered";
    private final BaseItemHandler patternsInventory;
    private final ICraftingPattern[] patterns;
    private boolean visited;
    private boolean invalidateNextTick;
    private CrafterMode mode;
    private boolean locked;
    private boolean wasPowered;
    @Nullable
    private ITextComponent displayName;
    @Nullable
    private UUID uuid;
    public static final ResourceLocation ID = new ResourceLocation("creativecrafter", "creative_crafter");
    private static final ITextComponent DEFAULT_NAME = new TranslationTextComponent("gui.creativecrafter.creative_crafter");

    public CreativeCrafterNetworkNode(World world, BlockPos pos) {
        super(world, pos);
        this.patternsInventory = new BaseItemHandler(108){

            public int getSlotLimit(int slot) {
                return 1;
            }
        }.addValidator((Predicate)new PatternItemValidator(this.world)).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
            if (!reading) {
                if (!this.world.field_72995_K) {
                    this.invalidateSlot(slot);
                }
                this.invalidateNextTick = true;
            }
        });
        this.patterns = new ICraftingPattern[this.patternsInventory.getSlots()];
        this.visited = false;
        this.invalidateNextTick = false;
        this.mode = CrafterMode.IGNORE;
        this.locked = false;
        this.uuid = null;
    }

    private void invalidate() {
        for (int slot = 0; slot < this.patternsInventory.getSlots(); ++slot) {
            this.invalidateSlot(slot);
        }
    }

    private void invalidateSlot(int slot) {
        this.patterns[slot] = null;
        ItemStack patternStack = this.patternsInventory.getStackInSlot(slot);
        if (patternStack.func_190926_b()) {
            return;
        }
        ICraftingPattern pattern = ((ICraftingPatternProvider)patternStack.func_77973_b()).create(this.world, patternStack, (ICraftingPatternContainer)this);
        if (pattern.isValid()) {
            this.patterns[slot] = pattern;
        }
    }

    public int getEnergyUsage() {
        return (Integer)CreativeCrafterConfig.CREATIVE_CRAFTER_RF_CONSUME.get();
    }

    public void update() {
        super.update();
        if (this.ticks == 1) {
            this.invalidate();
        }
        if (this.invalidateNextTick) {
            this.invalidateNextTick = false;
            if (this.network != null) {
                this.network.getCraftingManager().invalidate();
            }
        }
        if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET && this.world.func_195588_v(this.pos)) {
            if (this.world.func_175640_z(this.pos)) {
                this.wasPowered = true;
                this.markDirty();
            } else if (this.wasPowered) {
                this.wasPowered = false;
                this.locked = false;
                this.markDirty();
            }
        }
    }

    protected void onConnectedStateChange(INetwork network, boolean state, ConnectivityStateChangeCause cause) {
        super.onConnectedStateChange(network, state, cause);
        network.getCraftingManager().invalidate();
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        network.getCraftingManager().getTasks().stream().filter(task -> task.getPattern().getContainer().getPosition().equals((Object)this.pos)).forEach(task -> network.getCraftingManager().cancel(task.getId()));
    }

    public void onDirectionChanged(Direction direction) {
        super.onDirectionChanged(direction);
        if (this.network != null) {
            this.network.getCraftingManager().invalidate();
        }
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.patternsInventory, (int)0, (CompoundNBT)tag);
        this.invalidate();
        if (tag.func_74764_b(NBT_DISPLAY_NAME)) {
            this.displayName = ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i(NBT_DISPLAY_NAME));
        }
        if (tag.func_186855_b(NBT_UUID)) {
            this.uuid = tag.func_186857_a(NBT_UUID);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = CrafterMode.getById(tag.func_74762_e(NBT_MODE));
        }
        if (tag.func_74764_b(NBT_LOCKED)) {
            this.locked = tag.func_74767_n(NBT_LOCKED);
        }
        if (tag.func_74764_b(NBT_WAS_POWERED)) {
            this.wasPowered = tag.func_74767_n(NBT_WAS_POWERED);
        }
    }

    public ResourceLocation getId() {
        return ID;
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.patternsInventory, (int)0, (CompoundNBT)tag);
        if (this.displayName != null) {
            tag.func_74778_a(NBT_DISPLAY_NAME, ITextComponent.Serializer.func_150696_a((ITextComponent)this.displayName));
        }
        if (this.uuid != null) {
            tag.func_186854_a(NBT_UUID, this.uuid);
        }
        tag.func_74768_a(NBT_MODE, this.mode.ordinal());
        tag.func_74757_a(NBT_LOCKED, this.locked);
        tag.func_74757_a(NBT_WAS_POWERED, this.wasPowered);
        return tag;
    }

    public int getUpdateInterval() {
        return 0;
    }

    public int getMaximumSuccessfulCraftingUpdates() {
        return (Integer)CreativeCrafterConfig.CREATIVE_CRAFTER_SPEED.get();
    }

    @Nullable
    public IItemHandler getConnectedInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getItemHandler((TileEntity)proxy.getFacingTile(), (Direction)proxy.getDirection().func_176734_d());
    }

    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return WorldUtils.getFluidHandler((TileEntity)proxy.getFacingTile(), (Direction)proxy.getDirection().func_176734_d());
    }

    @Nullable
    public TileEntity getConnectedTile() {
        ICraftingPatternContainer proxy = this.getRootContainer();
        if (proxy == null) {
            return null;
        }
        return proxy.getFacingTile();
    }

    @Nullable
    public TileEntity getFacingTile() {
        BlockPos facingPos = this.pos.func_177972_a(this.getDirection());
        if (!this.world.func_195588_v(facingPos)) {
            return null;
        }
        return this.world.func_175625_s(facingPos);
    }

    public List<ICraftingPattern> getPatterns() {
        return Arrays.stream(this.patterns).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public IItemHandlerModifiable getPatternInventory() {
        return this.patternsInventory;
    }

    public ITextComponent getName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        TileEntity facing = this.getConnectedTile();
        if (facing instanceof INameable && ((INameable)facing).func_200200_C_() != null) {
            return ((INameable)facing).func_200200_C_();
        }
        if (facing != null) {
            return new TranslationTextComponent(this.world.func_180495_p(facing.func_174877_v()).func_177230_c().func_149739_a());
        }
        return DEFAULT_NAME;
    }

    public void setDisplayName(ITextComponent displayName) {
        this.displayName = displayName;
    }

    @Nullable
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public CrafterMode getMode() {
        return this.mode;
    }

    public void setMode(CrafterMode mode) {
        this.mode = mode;
        this.wasPowered = false;
        this.locked = false;
        this.markDirty();
    }

    public IItemHandler getPatternItems() {
        return this.patternsInventory;
    }

    @Nullable
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.patternsInventory});
    }

    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        if (this.visited) {
            return null;
        }
        INetworkNode facing = API.instance().getNetworkNodeManager((ServerWorld)this.world).getNode(this.pos.func_177972_a(this.getDirection()));
        if (!(facing instanceof ICraftingPatternContainer) || facing.getNetwork() != this.network) {
            return this;
        }
        this.visited = true;
        ICraftingPatternContainer facingContainer = ((ICraftingPatternContainer)facing).getRootContainer();
        this.visited = false;
        return facingContainer;
    }

    public Optional<ICraftingPatternContainer> getRootContainerNotSelf() {
        ICraftingPatternContainer root = this.getRootContainer();
        if (root != null && root != this) {
            return Optional.of(root);
        }
        return Optional.empty();
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
            this.markDirty();
        }
        return this.uuid;
    }

    public boolean isLocked() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            return root.get().isLocked();
        }
        switch (this.mode) {
            case SIGNAL_LOCKS_AUTOCRAFTING: {
                return this.world.func_175640_z(this.pos);
            }
            case SIGNAL_UNLOCKS_AUTOCRAFTING: {
                return !this.world.func_175640_z(this.pos);
            }
            case PULSE_INSERTS_NEXT_SET: {
                return this.locked;
            }
        }
        return false;
    }

    public void unlock() {
        this.locked = false;
    }

    public void onUsedForProcessing() {
        Optional<ICraftingPatternContainer> root = this.getRootContainerNotSelf();
        if (root.isPresent()) {
            root.get().onUsedForProcessing();
        } else if (this.mode == CrafterMode.PULSE_INSERTS_NEXT_SET) {
            this.locked = true;
            this.markDirty();
        }
    }

    public static enum CrafterMode {
        IGNORE,
        SIGNAL_UNLOCKS_AUTOCRAFTING,
        SIGNAL_LOCKS_AUTOCRAFTING,
        PULSE_INSERTS_NEXT_SET;


        public static CrafterMode getById(int id) {
            if (id >= 0 && id < CrafterMode.values().length) {
                return CrafterMode.values()[id];
            }
            return IGNORE;
        }
    }
}

