/*
 * Decompiled with CFR 0.152.
 */
package com.YTrollman.CreativeApiary.block;

import com.YTrollman.CreativeApiary.config.CreativeApiaryConfig;
import com.YTrollman.CreativeApiary.tileentity.CreativeApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.block.multiblocks.apiary.ApiaryBlock;
import com.resourcefulbees.resourcefulbees.lib.ApiaryOutput;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class CreativeApiaryBlock
extends ApiaryBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty VALIDATED = BooleanProperty.func_177716_a((String)"validated");
    private final int tier;

    public CreativeApiaryBlock(int tier, float hardness, float resistance) {
        super(100, hardness, resistance);
        this.tier = tier;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)VALIDATED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand handIn, @Nonnull BlockRayTraceResult hit) {
        if (!player.func_225608_bj_() && !world.field_72995_K) {
            INamedContainerProvider blockEntity = state.func_215699_b(world, pos);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)blockEntity, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return context.func_195999_j() != null && context.func_195999_j().func_225608_bj_() ? (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f()) : (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{VALIDATED, FACING});
    }

    @Nullable
    public INamedContainerProvider func_220052_b(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos) {
        return (INamedContainerProvider)worldIn.func_175625_s(pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CreativeApiaryTileEntity();
    }

    public void func_180633_a(World worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CreativeApiaryTileEntity) {
            CreativeApiaryTileEntity apiaryTileEntity = (CreativeApiaryTileEntity)tile;
            apiaryTileEntity.setTier(this.tier);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.beehive.tooltip.max_bees", (Object[])new Object[0])).appendText(" " + CreativeApiaryConfig.TCREATIVE_APIARY_MAX_BEES.get()).appendText(TextFormatting.GOLD + " Bees", TextFormatting.RESET).applyStyle(TextFormatting.GOLD).build());
            int number = (int)((Double)CreativeApiaryConfig.TCREATIVE_APIARY_SPEED.get() * 100.0);
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.creativeapiary.creative_apiary.tooltip.speed", (Object[])new Object[0]) + number + "% tick reduction", TextFormatting.GOLD).build());
            ApiaryOutput outputTypeEnum = (ApiaryOutput)CreativeApiaryConfig.TCREATIVE_APIARY_OUTPUT.get();
            int outputQuantity = (Integer)CreativeApiaryConfig.TCREATIVE_APIARY_QUANTITY.get();
            String outputType = outputTypeEnum.equals((Object)ApiaryOutput.COMB) ? I18n.func_135052_a((String)"honeycomb.resourcefulbees", (Object[])new Object[0]) : I18n.func_135052_a((String)"honeycomb_block.resourcefulbees", (Object[])new Object[0]);
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.output_type", (Object[])new Object[0])).appendText(" " + outputType).applyStyle(TextFormatting.GOLD).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.output_quantity", (Object[])new Object[0])).appendText(" " + outputQuantity).applyStyle(TextFormatting.GOLD).build());
        } else if (Screen.func_231172_r_()) {
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.structure_size", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.creativeapiary.creative_apiary.tooltip.requisites", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.drops", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.tags", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.offset", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.lock", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.lock_2", (Object[])new Object[0]), TextFormatting.AQUA).build());
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"resourcefulbees.shift_info", (Object[])new Object[0])));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.AQUA + I18n.func_135052_a((String)"resourcefulbees.ctrl_info", (Object[])new Object[0])));
        }
    }
}

