/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.item;

import com.mojang.authlib.GameProfile;
import com.mrh0.createaddition.energy.IWireNode;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class Multimeter
extends Item {
    public Multimeter(Item.Properties props) {
        super(props);
    }

    public ActionResultType func_195939_a(ItemUseContext c) {
        TileEntity te = c.func_195991_k().func_175625_s(c.func_195995_a());
        if (te != null && !c.func_195991_k().func_201670_d()) {
            LazyOptional cap = te.getCapability(CapabilityEnergy.ENERGY, c.func_196000_l());
            if (te instanceof IWireNode) {
                IWireNode wn = (IWireNode)te;
                for (int i = 0; i < wn.getNodeCount(); ++i) {
                    System.out.println(wn.getNetwork(i));
                }
            }
            if (cap != null) {
                IEnergyStorage energy = (IEnergyStorage)cap.orElse(null);
                String measur = new TranslationTextComponent("item.createaddition.multimeter.measuring").func_212636_a(Integer.MAX_VALUE);
                CompoundNBT tag = c.func_195996_i().func_77978_p();
                if (tag == null) {
                    tag = new CompoundNBT();
                }
                if (Multimeter.hasPos(tag)) {
                    if (Multimeter.posEquals(tag, c.func_195995_a(), c.func_196000_l())) {
                        int de = Multimeter.getDeltaEnergy(tag, energy != null ? energy.getEnergyStored() : 0);
                        long dt = Multimeter.getDeltaTime(tag, c.func_195991_k().func_82737_E());
                        measur = " [" + (dt > 0L ? (long)de / dt : 0L) + "fe/t (" + dt + new TranslationTextComponent("item.createaddition.multimeter.ticks").func_212636_a(Integer.MAX_VALUE) + ")]";
                        Multimeter.clearPos(tag);
                    } else {
                        Multimeter.setContent(tag, c.func_195995_a(), c.func_196000_l(), c.func_195991_k().func_82737_E(), energy != null ? energy.getEnergyStored() : 0);
                    }
                } else {
                    Multimeter.setContent(tag, c.func_195995_a(), c.func_196000_l(), c.func_195991_k().func_82737_E(), energy != null ? energy.getEnergyStored() : 0);
                }
                c.func_195996_i().func_77982_d(tag);
                c.func_195999_j().func_145747_a((ITextComponent)new TranslationTextComponent("item.createaddition.multimeter.title").func_230529_a_((ITextComponent)new StringTextComponent(" ").func_230529_a_(Multimeter.getTextComponent(energy, new TranslationTextComponent("item.createaddition.multimeter.no_capability").func_212636_a(Integer.MAX_VALUE), "fe")).func_230529_a_((ITextComponent)new StringTextComponent(" " + measur))), PlayerEntity.func_146094_a((GameProfile)c.func_195999_j().func_146103_bH()));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public static ITextComponent getTextComponent(IEnergyStorage ies, String nan, String unit) {
        if (ies == null) {
            return new StringTextComponent(nan);
        }
        return new StringTextComponent(Multimeter.format(ies.getEnergyStored()) + unit).func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new StringTextComponent(" / ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new StringTextComponent(Multimeter.format(ies.getMaxEnergyStored()) + unit));
    }

    public static ITextComponent getTextComponent(IEnergyStorage ies) {
        return Multimeter.getTextComponent(ies, "NaN", "fe");
    }

    public static String format(int n) {
        if (n > 1000000) {
            return (double)Math.round((double)n / 100000.0) / 10.0 + "M";
        }
        if (n > 1000) {
            return (double)Math.round((double)n / 100.0) / 10.0 + "K";
        }
        return n + "";
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt = stack.func_77978_p();
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (Multimeter.hasPos(nbt)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.createaddition.multimeter.measuring"));
        }
    }

    public static boolean hasPos(CompoundNBT nbt) {
        if (nbt == null) {
            return false;
        }
        return nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z") && nbt.func_74764_b("side");
    }

    public static BlockPos getPos(CompoundNBT nbt) {
        if (nbt == null) {
            return null;
        }
        return new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
    }

    public static int getDeltaEnergy(CompoundNBT nbt, int now) {
        if (nbt == null) {
            return 0;
        }
        int r = now - nbt.func_74762_e("start");
        return r;
    }

    public static long getDeltaTime(CompoundNBT nbt, long now) {
        if (nbt == null) {
            return 0L;
        }
        long r = now - nbt.func_74763_f("tick");
        return r > 0L ? r : 0L;
    }

    public static Direction getDirection(CompoundNBT nbt) {
        if (nbt == null) {
            return null;
        }
        return Direction.func_82600_a((int)nbt.func_74762_e("side"));
    }

    public static boolean posEquals(CompoundNBT nbt, BlockPos pos, Direction dir) {
        return nbt.func_74762_e("x") == pos.func_177958_n() && nbt.func_74762_e("y") == pos.func_177956_o() && nbt.func_74762_e("z") == pos.func_177952_p() && nbt.func_74762_e("side") == dir.func_176745_a();
    }

    public static void clearPos(CompoundNBT nbt) {
        nbt.func_82580_o("x");
        nbt.func_82580_o("y");
        nbt.func_82580_o("z");
        nbt.func_82580_o("side");
        nbt.func_82580_o("tick");
        nbt.func_82580_o("start");
    }

    public static CompoundNBT setContent(CompoundNBT nbt, BlockPos pos, Direction dir, long tick, int energy) {
        if (nbt == null) {
            return new CompoundNBT();
        }
        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
        nbt.func_74768_a("side", dir.func_176745_a());
        nbt.func_74772_a("tick", tick);
        nbt.func_74768_a("start", energy);
        return nbt;
    }
}

