/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.worldgen.ConfigDrivenDecorator;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreFeature;
import com.simibubi.create.foundation.worldgen.ConfigDrivenOreFeatureConfig;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigDrivenFeatureEntry
extends ConfigBase {
    public final String id;
    public final NonNullSupplier<? extends Block> block;
    protected ConfigBase.ConfigInt clusterSize;
    protected ConfigBase.ConfigInt minHeight;
    protected ConfigBase.ConfigInt maxHeight;
    protected ConfigBase.ConfigFloat frequency;
    Optional<ConfiguredFeature<?, ?>> feature = Optional.empty();

    public ConfigDrivenFeatureEntry(String id, NonNullSupplier<? extends Block> block, int clusterSize, float frequency) {
        this.id = id;
        this.block = block;
        this.clusterSize = this.i(clusterSize, 0, "clusterSize", new String[0]);
        this.minHeight = this.i(0, 0, "minHeight", new String[0]);
        this.maxHeight = this.i(256, 0, "maxHeight", new String[0]);
        this.frequency = this.f(frequency, 0.0f, 512.0f, "frequency", "Amount of clusters generated per Chunk.", "  >1 to spawn multiple.", "  <1 to make it a chance.", "  0 to disable.");
    }

    public ConfigDrivenFeatureEntry between(int minHeight, int maxHeight) {
        this.allValues.remove(this.minHeight);
        this.allValues.remove(this.maxHeight);
        this.minHeight = this.i(minHeight, 0, "minHeight", new String[0]);
        this.maxHeight = this.i(maxHeight, 0, "maxHeight", new String[0]);
        return this;
    }

    public ConfiguredFeature<?, ?> getFeature() {
        if (!this.feature.isPresent()) {
            this.feature = Optional.of(this.createFeature());
        }
        return this.feature.get();
    }

    private ConfiguredFeature<?, ?> createFeature() {
        ConfigDrivenOreFeatureConfig config = new ConfigDrivenOreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, this.block.get().func_176223_P(), this.id);
        return ConfigDrivenOreFeature.INSTANCE.func_225566_b_(config).func_227228_a_(ConfigDrivenDecorator.INSTANCE.func_227446_a_(config));
    }

    public void addToConfig(ForgeConfigSpec.Builder builder) {
        this.registerAll(builder);
    }

    @Override
    public String getName() {
        return this.id;
    }
}

