/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RaycastHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber
public class FilteringHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        if (player.func_225608_bj_() || player.func_175149_v()) {
            return;
        }
        FilteringBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        BlockRayTraceResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        if (behaviour instanceof SidedFilteringBehaviour && (behaviour = ((SidedFilteringBehaviour)behaviour).get(ray.func_216354_b())) == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)behaviour.slotPositioning).fromSide(ray.func_216354_b());
        }
        if (!behaviour.testHit(ray.func_216347_e())) {
            return;
        }
        ItemStack toApply = player.func_184586_b(hand).func_77946_l();
        if (AllItems.WRENCH.isIn(toApply)) {
            return;
        }
        if (AllBlocks.MECHANICAL_ARM.isIn(toApply)) {
            return;
        }
        if (event.getSide() != LogicalSide.CLIENT) {
            if (!player.func_184812_l_()) {
                if (toApply.func_77973_b() instanceof FilterItem) {
                    player.func_184586_b(hand).func_190918_g(1);
                }
                if (behaviour.getFilter().func_77973_b() instanceof FilterItem) {
                    player.field_71071_by.func_191975_a(world, behaviour.getFilter());
                }
            }
            if (toApply.func_77973_b() instanceof FilterItem) {
                toApply.func_190920_e(1);
            }
            behaviour.setFilter(toApply);
        } else {
            ItemStack filter = behaviour.getFilter();
            String feedback = "apply_click_again";
            if (toApply.func_77973_b() instanceof FilterItem || !behaviour.isCountVisible()) {
                feedback = "apply";
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)toApply, (ItemStack)filter)) {
                feedback = "apply_count";
            }
            String translationKey = world.func_180495_p(pos).func_177230_c().func_149739_a();
            TranslationTextComponent formattedText = new TranslationTextComponent(translationKey);
            player.func_146105_b((ITextComponent)Lang.createTranslationTextComponent("logistics.filter." + feedback, formattedText).func_240699_a_(TextFormatting.WHITE), true);
        }
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
        world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 0.25f, 0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean onScroll(double delta) {
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        BlockPos blockPos = result.func_216350_a();
        FilteringBehaviour filtering = TileEntityBehaviour.get((IBlockReader)world, blockPos, FilteringBehaviour.TYPE);
        if (filtering == null) {
            return false;
        }
        if (mc.field_71439_g.func_225608_bj_()) {
            return false;
        }
        if (!mc.field_71439_g.func_175142_cm()) {
            return false;
        }
        if (!filtering.isCountVisible()) {
            return false;
        }
        if (!filtering.isActive()) {
            return false;
        }
        if (filtering.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)filtering.slotPositioning).fromSide(result.func_216354_b());
        }
        if (!filtering.testHit(objectMouseOver.func_216347_e())) {
            return false;
        }
        ItemStack filterItem = filtering.getFilter();
        filtering.ticksUntilScrollPacket = 10;
        int maxAmount = filterItem.func_77973_b() instanceof FilterItem ? 64 : filterItem.func_77976_d();
        int prev = filtering.scrollableValue;
        filtering.scrollableValue = (int)MathHelper.func_151237_a((double)((double)filtering.scrollableValue + delta * (double)(AllKeys.ctrlDown() ? 16 : 1)), (double)0.0, (double)maxAmount);
        if (prev != filtering.scrollableValue) {
            float pitch = (float)filtering.scrollableValue / (float)maxAmount;
            pitch = MathHelper.func_219799_g((float)pitch, (float)1.5f, (float)2.0f);
            AllSoundEvents.SCROLL_VALUE.play((World)world, (PlayerEntity)mc.field_71439_g, blockPos, 1.0f, pitch);
        }
        return true;
    }
}

