/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.belt;

import com.simibubi.create.content.contraptions.relays.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BeltProcessingBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<BeltProcessingBehaviour> TYPE = new BehaviourType();
    private ProcessingCallback onItemEnter = (s, i) -> ProcessingResult.PASS;
    private ProcessingCallback continueProcessing = (s, i) -> ProcessingResult.PASS;

    public BeltProcessingBehaviour(SmartTileEntity te) {
        super(te);
    }

    public BeltProcessingBehaviour whenItemEnters(ProcessingCallback callback) {
        this.onItemEnter = callback;
        return this;
    }

    public BeltProcessingBehaviour whileItemHeld(ProcessingCallback callback) {
        this.continueProcessing = callback;
        return this;
    }

    public static boolean isBlocked(IBlockReader world, BlockPos processingSpace) {
        BlockState blockState = world.func_180495_p(processingSpace.func_177984_a());
        if (AbstractFunnelBlock.isFunnel(blockState)) {
            return false;
        }
        return !blockState.func_196952_d(world, processingSpace.func_177984_a()).func_197766_b();
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public ProcessingResult handleReceivedItem(TransportedItemStack stack, TransportedItemStackHandlerBehaviour inventory) {
        return this.onItemEnter.apply(stack, inventory);
    }

    public ProcessingResult handleHeldItem(TransportedItemStack stack, TransportedItemStackHandlerBehaviour inventory) {
        return this.continueProcessing.apply(stack, inventory);
    }

    @FunctionalInterface
    public static interface ProcessingCallback {
        public ProcessingResult apply(TransportedItemStack var1, TransportedItemStackHandlerBehaviour var2);
    }

    public static enum ProcessingResult {
        PASS,
        HOLD,
        REMOVE;

    }
}

