/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.ILightingSettings;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public class CustomLightingSettings
implements ILightingSettings {
    private Vector3f light1;
    private Vector3f light2;
    private Matrix4f lightMatrix;

    protected CustomLightingSettings(float yRot, float xRot) {
        this.init(yRot, xRot, 0.0f, 0.0f, false);
    }

    protected CustomLightingSettings(float yRot1, float xRot1, float yRot2, float xRot2) {
        this.init(yRot1, xRot1, yRot2, xRot2, true);
    }

    protected void init(float yRot1, float xRot1, float yRot2, float xRot2, boolean doubleLight) {
        this.light1 = Vector3f.field_229183_f_.func_229195_e_();
        this.light1.func_214905_a(Vector3f.field_229181_d_.func_229187_a_(yRot1));
        this.light1.func_214905_a(Vector3f.field_229179_b_.func_229187_a_(xRot1));
        if (doubleLight) {
            this.light2 = Vector3f.field_229183_f_.func_229195_e_();
            this.light2.func_214905_a(Vector3f.field_229181_d_.func_229187_a_(yRot2));
            this.light2.func_214905_a(Vector3f.field_229179_b_.func_229187_a_(xRot2));
        } else {
            this.light2 = VecHelper.ZERO_3F;
        }
        this.lightMatrix = new Matrix4f();
        this.lightMatrix.func_226591_a_();
    }

    @Override
    public void applyLighting() {
        RenderSystem.setupLevelDiffuseLighting((Vector3f)this.light1, (Vector3f)this.light2, (Matrix4f)this.lightMatrix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private float yRot1;
        private float xRot1;
        private float yRot2;
        private float xRot2;
        private boolean doubleLight;

        public Builder firstLightRotation(float yRot, float xRot) {
            this.yRot1 = yRot;
            this.xRot1 = xRot;
            return this;
        }

        public Builder secondLightRotation(float yRot, float xRot) {
            this.yRot2 = yRot;
            this.xRot2 = xRot;
            this.doubleLight = true;
            return this;
        }

        public Builder doubleLight() {
            this.doubleLight = true;
            return this;
        }

        public CustomLightingSettings build() {
            if (this.doubleLight) {
                return new CustomLightingSettings(this.yRot1, this.xRot1, this.yRot2, this.xRot2);
            }
            return new CustomLightingSettings(this.yRot1, this.xRot1);
        }
    }
}

