/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractSimiScreen
extends Screen {
    protected int windowWidth;
    protected int windowHeight;
    protected int windowXOffset;
    protected int windowYOffset;
    protected int guiLeft;
    protected int guiTop;
    protected List<Widget> widgets = new ArrayList<Widget>();

    protected AbstractSimiScreen(ITextComponent title) {
        super(title);
    }

    protected AbstractSimiScreen() {
        this((ITextComponent)new StringTextComponent(""));
    }

    protected void setWindowSize(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    protected void setWindowOffset(int xOffset, int yOffset) {
        this.windowXOffset = xOffset;
        this.windowYOffset = yOffset;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.windowWidth) / 2;
        this.guiTop = (this.field_230709_l_ - this.windowHeight) / 2;
        this.guiLeft += this.windowXOffset;
        this.guiTop += this.windowYOffset;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.widgets.stream().filter(w -> w instanceof AbstractSimiWidget).forEach(w -> ((AbstractSimiWidget)((Object)w)).tick());
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        partialTicks = partialTicks == 10.0f ? 0.0f : Minecraft.func_71410_x().func_184121_ak();
        ms.func_227860_a_();
        this.prepareFrame();
        this.renderWindowBackground(ms, mouseX, mouseY, partialTicks);
        this.renderWindow(ms, mouseX, mouseY, partialTicks);
        for (Widget widget : this.widgets) {
            widget.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        }
        this.renderWindowForeground(ms, mouseX, mouseY, partialTicks);
        this.endFrame();
        ms.func_227865_b_();
    }

    protected void prepareFrame() {
    }

    protected void endFrame() {
    }

    protected void renderWindowBackground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.func_231044_a_(x, y, button)) continue;
            result = true;
        }
        if (!result) {
            result = super.func_231044_a_(x, y, button);
        }
        return result;
    }

    public boolean func_231046_a_(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        for (Widget widget : this.widgets) {
            if (!widget.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        if (super.func_231046_a_(code, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)code, (int)p_keyPressed_2_);
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.func_231175_as__();
            return true;
        }
        return false;
    }

    public boolean func_231042_a_(char character, int code) {
        for (Widget widget : this.widgets) {
            if (!widget.func_231042_a_(character, code)) continue;
            return true;
        }
        return super.func_231042_a_(character, code);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        for (Widget widget : this.widgets) {
            if (!widget.func_231043_a_(mouseX, mouseY, delta)) continue;
            return true;
        }
        return super.func_231043_a_(mouseX, mouseY, delta);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        boolean result = false;
        for (Widget widget : this.widgets) {
            if (!widget.func_231048_c_(x, y, button)) continue;
            result = true;
        }
        return result | super.func_231048_c_(x, y, button);
    }

    public boolean func_231178_ax__() {
        return true;
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected abstract void renderWindow(MatrixStack var1, int var2, int var3, float var4);

    protected void renderWindowForeground(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        for (Widget widget : this.widgets) {
            if (!widget.func_230449_g_()) continue;
            if (widget instanceof AbstractSimiWidget) {
                if (((AbstractSimiWidget)widget).getToolTip().isEmpty()) continue;
                this.func_243308_b(ms, ((AbstractSimiWidget)widget).getToolTip(), mouseX, mouseY);
                continue;
            }
            widget.func_230443_a_(ms, mouseX, mouseY);
        }
    }

    @Deprecated
    protected void debugWindowArea(MatrixStack matrixStack) {
        AbstractSimiScreen.func_238467_a_((MatrixStack)matrixStack, (int)(this.guiLeft + this.windowWidth), (int)(this.guiTop + this.windowHeight), (int)this.guiLeft, (int)this.guiTop, (int)-741092397);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }
}

