/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.config.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.ui.ConfigHelper;
import com.simibubi.create.foundation.config.ui.ConfigModListScreen;
import com.simibubi.create.foundation.config.ui.ConfigScreen;
import com.simibubi.create.foundation.config.ui.SubMenuConfigScreen;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.DelegatedStencilElement;
import com.simibubi.create.foundation.gui.RenderElement;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.TextStencilElement;
import com.simibubi.create.foundation.gui.Theme;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.BoxWidget;
import com.simibubi.create.foundation.gui.widgets.ElementWidget;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class BaseConfigScreen
extends ConfigScreen {
    public static final DelegatedStencilElement.ElementRenderer DISABLED_RENDERER = (ms, width, height, alpha) -> UIRenderHelper.angledGradient(ms, 0.0f, 0, height / 2, height, width, Theme.p(Theme.Key.BUTTON_DISABLE));
    private static final Map<String, UnaryOperator<BaseConfigScreen>> defaults = new HashMap<String, UnaryOperator<BaseConfigScreen>>();
    BoxWidget clientConfigWidget;
    BoxWidget commonConfigWidget;
    BoxWidget serverConfigWidget;
    BoxWidget goBack;
    BoxWidget others;
    BoxWidget field_230704_d_;
    ForgeConfigSpec clientSpec;
    ForgeConfigSpec commonSpec;
    ForgeConfigSpec serverSpec;
    String clientTile = "Client Config";
    String commonTile = "Common Config";
    String serverTile = "Server Config";
    String modID;
    protected boolean returnOnClose;

    public static void setDefaultActionFor(String modID, UnaryOperator<BaseConfigScreen> transform) {
        if (modID.equalsIgnoreCase("create")) {
            return;
        }
        defaults.put(modID, transform);
    }

    public static BaseConfigScreen forCreate(Screen parent) {
        return new BaseConfigScreen(parent);
    }

    public BaseConfigScreen(Screen parent, @Nonnull String modID) {
        super(parent);
        this.modID = modID;
        if (defaults.containsKey(modID)) {
            defaults.get(modID).apply(this);
        } else {
            this.searchForSpecsInModContainer();
        }
    }

    private BaseConfigScreen(Screen parent) {
        this(parent, "create");
    }

    public BaseConfigScreen searchForSpecsInModContainer() {
        if (!ConfigHelper.hasAnyConfig(this.modID)) {
            return this;
        }
        try {
            this.clientSpec = ConfigHelper.findConfigSpecFor(ModConfig.Type.CLIENT, this.modID);
        }
        catch (Exception e) {
            Create.LOGGER.debug("Unable to find ClientConfigSpec for mod: " + this.modID);
        }
        try {
            this.commonSpec = ConfigHelper.findConfigSpecFor(ModConfig.Type.COMMON, this.modID);
        }
        catch (Exception e) {
            Create.LOGGER.debug("Unable to find CommonConfigSpec for mod: " + this.modID);
        }
        try {
            this.serverSpec = ConfigHelper.findConfigSpecFor(ModConfig.Type.SERVER, this.modID);
        }
        catch (Exception e) {
            Create.LOGGER.debug("Unable to find ServerConfigSpec for mod: " + this.modID);
        }
        return this;
    }

    public BaseConfigScreen withSpecs(@Nullable ForgeConfigSpec client, @Nullable ForgeConfigSpec common, @Nullable ForgeConfigSpec server) {
        this.clientSpec = client;
        this.commonSpec = common;
        this.serverSpec = server;
        return this;
    }

    public BaseConfigScreen withTitles(@Nullable String client, @Nullable String common, @Nullable String server) {
        if (client != null) {
            this.clientTile = client;
        }
        if (common != null) {
            this.commonTile = common;
        }
        if (server != null) {
            this.serverTile = server;
        }
        return this;
    }

    @Override
    protected void func_231160_c_() {
        this.widgets.clear();
        super.func_231160_c_();
        this.returnOnClose = true;
        TextStencilElement clientText = new TextStencilElement(this.field_230706_i_.field_71466_p, (IFormattableTextComponent)new StringTextComponent(this.clientTile)).centered(true, true);
        this.clientConfigWidget = (BoxWidget)((Object)new BoxWidget(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 15 - 30, 200, 16).showingElement(clientText));
        this.widgets.add(this.clientConfigWidget);
        if (this.clientSpec != null) {
            this.clientConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.CLIENT, this.clientSpec)));
            clientText.withElementRenderer(BoxWidget.gradientFactory.apply(this.clientConfigWidget));
        } else {
            this.clientConfigWidget.field_230693_o_ = false;
            this.clientConfigWidget.updateColorsFromState();
            clientText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement commonText = new TextStencilElement(this.field_230706_i_.field_71466_p, (IFormattableTextComponent)new StringTextComponent(this.commonTile)).centered(true, true);
        this.commonConfigWidget = (BoxWidget)((Object)new BoxWidget(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 15, 200, 16).showingElement(commonText));
        this.widgets.add(this.commonConfigWidget);
        if (this.commonSpec != null) {
            this.commonConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.COMMON, this.commonSpec)));
            commonText.withElementRenderer(BoxWidget.gradientFactory.apply(this.commonConfigWidget));
        } else {
            this.commonConfigWidget.field_230693_o_ = false;
            this.commonConfigWidget.updateColorsFromState();
            commonText.withElementRenderer(DISABLED_RENDERER);
        }
        TextStencilElement serverText = new TextStencilElement(this.field_230706_i_.field_71466_p, (IFormattableTextComponent)new StringTextComponent(this.serverTile)).centered(true, true);
        this.serverConfigWidget = (BoxWidget)((Object)new BoxWidget(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 15 + 30, 200, 16).showingElement(serverText));
        this.widgets.add(this.serverConfigWidget);
        if (this.serverSpec == null) {
            this.serverConfigWidget.field_230693_o_ = false;
            this.serverConfigWidget.updateColorsFromState();
            serverText.withElementRenderer(DISABLED_RENDERER);
        } else if (Minecraft.func_71410_x().field_71441_e == null) {
            serverText.withElementRenderer(DISABLED_RENDERER);
            this.serverConfigWidget.getToolTip().add((ITextComponent)new StringTextComponent("Stored individually per World"));
            this.serverConfigWidget.getToolTip().addAll(TooltipHelper.cutTextComponent((ITextComponent)new StringTextComponent("Gameplay settings can only be accessed from the in-game menu after joining a World or Server."), TextFormatting.GRAY, TextFormatting.GRAY));
        } else {
            this.serverConfigWidget.withCallback(() -> this.linkTo(new SubMenuConfigScreen(this, ModConfig.Type.SERVER, this.serverSpec)));
            serverText.withElementRenderer(BoxWidget.gradientFactory.apply(this.serverConfigWidget));
        }
        TextStencilElement titleText = (TextStencilElement)new TextStencilElement(this.field_230706_i_.field_71466_p, this.modID.toUpperCase(Locale.ROOT)).centered(true, true).withElementRenderer((ms, w, h, alpha) -> {
            UIRenderHelper.angledGradient(ms, 0.0f, 0, h / 2, h, w / 2, Theme.p(Theme.Key.CONFIG_TITLE_A));
            UIRenderHelper.angledGradient(ms, 0.0f, w / 2, h / 2, h, w / 2, Theme.p(Theme.Key.CONFIG_TITLE_B));
        });
        int boxWidth = this.field_230708_k_ + 10;
        int boxHeight = 39;
        int boxPadding = 4;
        this.field_230704_d_ = (BoxWidget)((Object)((ElementWidget)((Object)((ElementWidget)((Object)((ElementWidget)((Object)new BoxWidget(-5, this.field_230709_l_ / 2 - 110, boxWidth, boxHeight).withBorderColors(Theme.p(Theme.Key.BUTTON_IDLE)))).withPadding(0.0f, boxPadding))).rescaleElement((float)boxWidth / 2.0f, (float)(boxHeight - 2 * boxPadding) / 2.0f))).showingElement((RenderElement)titleText.at(0.0f, 7.0f)));
        this.field_230704_d_.field_230693_o_ = false;
        this.widgets.add(this.field_230704_d_);
        ConfigScreen.modID = this.modID;
        this.goBack = (BoxWidget)((Object)((AbstractSimiWidget)((Object)new BoxWidget(this.field_230708_k_ / 2 - 134, this.field_230709_l_ / 2, 20, 20).withPadding(2.0f, 2.0f))).withCallback(this::func_231175_as__));
        this.goBack.showingElement((RenderElement)AllIcons.I_CONFIG_BACK.asStencil().withElementRenderer(BoxWidget.gradientFactory.apply(this.goBack)));
        this.goBack.getToolTip().add((ITextComponent)new StringTextComponent("Go Back"));
        this.widgets.add(this.goBack);
        TextStencilElement othersText = new TextStencilElement(this.field_230706_i_.field_71466_p, (IFormattableTextComponent)new StringTextComponent("Access Configs of other Mods")).centered(true, true);
        this.others = (BoxWidget)((Object)new BoxWidget(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 - 15 + 90, 200, 16).showingElement(othersText));
        othersText.withElementRenderer(BoxWidget.gradientFactory.apply(this.others));
        this.others.withCallback(() -> this.linkTo(new ConfigModListScreen(this)));
        this.widgets.add(this.others);
    }

    @Override
    protected void renderWindow(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        BaseConfigScreen.func_238471_a_((MatrixStack)ms, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"Access Configs for Mod:", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 105), (int)Theme.i(Theme.Key.TEXT_ACCENT_STRONG));
    }

    private void linkTo(Screen screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        ScreenOpener.open(this.parent);
    }

    static {
        defaults.put("create", base -> base.withTitles("Client Settings", "World Generation Settings", "Gameplay Settings").withSpecs(AllConfigs.CLIENT.specification, AllConfigs.COMMON.specification, AllConfigs.SERVER.specification));
    }
}

