/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.jozufozu.flywheel.util.transform.MatrixTransformStack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingAngle;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public class SchematicTransformation {
    private InterpolatedChasingValue x = new InterpolatedChasingValue();
    private InterpolatedChasingValue y = new InterpolatedChasingValue();
    private InterpolatedChasingValue z = new InterpolatedChasingValue();
    private InterpolatedChasingValue scaleFrontBack = new InterpolatedChasingValue();
    private InterpolatedChasingValue scaleLeftRight = new InterpolatedChasingValue();
    private InterpolatedChasingAngle rotation = new InterpolatedChasingAngle();
    private double xOrigin;
    private double zOrigin;

    public void init(BlockPos anchor, PlacementSettings settings, AxisAlignedBB bounds) {
        int leftRight = settings.func_186212_b() == Mirror.LEFT_RIGHT ? -1 : 1;
        int frontBack = settings.func_186212_b() == Mirror.FRONT_BACK ? -1 : 1;
        this.getScaleFB().start(frontBack);
        this.getScaleLR().start(leftRight);
        this.xOrigin = bounds.func_216364_b() / 2.0;
        this.zOrigin = bounds.func_216362_d() / 2.0;
        int r = -(settings.func_186215_c().ordinal() * 90);
        this.rotation.start(r);
        Vector3d vec = this.fromAnchor(anchor);
        this.x.start((float)vec.field_72450_a);
        this.y.start((float)vec.field_72448_b);
        this.z.start((float)vec.field_72449_c);
    }

    public void applyGLTransformations(MatrixStack ms) {
        float pt = AnimationTickHolder.getPartialTicks();
        ms.func_227861_a_((double)this.x.get(pt), (double)this.y.get(pt), (double)this.z.get(pt));
        Vector3d rotationOffset = this.getRotationOffset(true);
        float fb = this.getScaleFB().get(pt);
        float lr = this.getScaleLR().get(pt);
        float rot = this.rotation.get(pt) + (float)(fb < 0.0f && lr < 0.0f ? 180 : 0);
        ms.func_227861_a_(this.xOrigin, 0.0, this.zOrigin);
        MatrixTransformStack.of((MatrixStack)ms).translate(rotationOffset).rotateY((double)rot).translateBack(rotationOffset);
        ms.func_227862_a_(Math.abs(fb), 1.0f, Math.abs(lr));
        ms.func_227861_a_(-this.xOrigin, 0.0, -this.zOrigin);
    }

    public boolean isFlipped() {
        return this.getMirrorModifier(Direction.Axis.X) < 0 != this.getMirrorModifier(Direction.Axis.Z) < 0;
    }

    public Vector3d getRotationOffset(boolean ignoreMirrors) {
        Vector3d rotationOffset = Vector3d.field_186680_a;
        if ((int)(this.zOrigin * 2.0) % 2 != (int)(this.xOrigin * 2.0) % 2) {
            float zIn;
            boolean xGreaterZ = this.xOrigin > this.zOrigin;
            float xIn = xGreaterZ ? 0.0f : 0.5f;
            float f = zIn = !xGreaterZ ? 0.0f : 0.5f;
            if (!ignoreMirrors) {
                xIn *= (float)this.getMirrorModifier(Direction.Axis.X);
                zIn *= (float)this.getMirrorModifier(Direction.Axis.Z);
            }
            rotationOffset = new Vector3d((double)xIn, 0.0, (double)zIn);
        }
        return rotationOffset;
    }

    public Vector3d toLocalSpace(Vector3d vec) {
        float pt = AnimationTickHolder.getPartialTicks();
        Vector3d rotationOffset = this.getRotationOffset(true);
        vec = vec.func_178786_a((double)this.x.get(pt), (double)this.y.get(pt), (double)this.z.get(pt));
        vec = vec.func_178786_a(this.xOrigin + rotationOffset.field_72450_a, 0.0, this.zOrigin + rotationOffset.field_72449_c);
        vec = VecHelper.rotate(vec, -this.rotation.get(pt), Direction.Axis.Y);
        vec = vec.func_72441_c(rotationOffset.field_72450_a, 0.0, rotationOffset.field_72449_c);
        vec = vec.func_216372_d((double)this.getScaleFB().get(pt), 1.0, (double)this.getScaleLR().get(pt));
        vec = vec.func_72441_c(this.xOrigin, 0.0, this.zOrigin);
        return vec;
    }

    public PlacementSettings toSettings() {
        boolean mirrorfb;
        PlacementSettings settings = new PlacementSettings();
        int i = (int)this.rotation.getTarget();
        boolean mirrorlr = this.getScaleLR().getTarget() < 0.0f;
        boolean bl = mirrorfb = this.getScaleFB().getTarget() < 0.0f;
        if (mirrorlr && mirrorfb) {
            mirrorfb = false;
            mirrorlr = false;
            i += 180;
        }
        if ((i %= 360) < 0) {
            i += 360;
        }
        Rotation rotation = Rotation.NONE;
        switch (i) {
            case 90: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case 180: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case 270: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
        }
        settings.func_186220_a(rotation);
        if (mirrorfb) {
            settings.func_186214_a(Mirror.FRONT_BACK);
        }
        if (mirrorlr) {
            settings.func_186214_a(Mirror.LEFT_RIGHT);
        }
        return settings;
    }

    public BlockPos getAnchor() {
        Vector3d vec = Vector3d.field_186680_a.func_72441_c(0.5, 0.0, 0.5);
        Vector3d rotationOffset = this.getRotationOffset(false);
        vec = vec.func_178786_a(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.func_178786_a(rotationOffset.field_72450_a, 0.0, rotationOffset.field_72449_c);
        vec = vec.func_216372_d((double)this.getScaleFB().getTarget(), 1.0, (double)this.getScaleLR().getTarget());
        vec = VecHelper.rotate(vec, this.rotation.getTarget(), Direction.Axis.Y);
        vec = vec.func_72441_c(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.func_72441_c((double)this.x.getTarget(), (double)this.y.getTarget(), (double)this.z.getTarget());
        return new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vector3d fromAnchor(BlockPos pos) {
        Vector3d vec = Vector3d.field_186680_a.func_72441_c(0.5, 0.0, 0.5);
        Vector3d rotationOffset = this.getRotationOffset(false);
        vec = vec.func_178786_a(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.func_178786_a(rotationOffset.field_72450_a, 0.0, rotationOffset.field_72449_c);
        vec = vec.func_216372_d((double)this.getScaleFB().getTarget(), 1.0, (double)this.getScaleLR().getTarget());
        vec = VecHelper.rotate(vec, this.rotation.getTarget(), Direction.Axis.Y);
        vec = vec.func_72441_c(this.xOrigin, 0.0, this.zOrigin);
        return Vector3d.func_237491_b_((Vector3i)pos.func_177973_b((Vector3i)new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
    }

    public int getRotationTarget() {
        return (int)this.rotation.getTarget();
    }

    public int getMirrorModifier(Direction.Axis axis) {
        if (axis == Direction.Axis.Z) {
            return (int)this.getScaleLR().getTarget();
        }
        return (int)this.getScaleFB().getTarget();
    }

    public float getCurrentRotation() {
        float pt = AnimationTickHolder.getPartialTicks();
        return this.rotation.get(pt);
    }

    public void tick() {
        this.x.tick();
        this.y.tick();
        this.z.tick();
        this.getScaleLR().tick();
        this.getScaleFB().tick();
        this.rotation.tick();
    }

    public void flip(Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            this.getScaleLR().target(this.getScaleLR().getTarget() * -1.0f);
        }
        if (axis == Direction.Axis.Z) {
            this.getScaleFB().target(this.getScaleFB().getTarget() * -1.0f);
        }
    }

    public void rotate90(boolean clockwise) {
        this.rotation.target(this.rotation.getTarget() + (float)(clockwise ? -90 : 90));
    }

    public void move(float xIn, float yIn, float zIn) {
        this.moveTo(this.x.getTarget() + xIn, this.y.getTarget() + yIn, this.z.getTarget() + zIn);
    }

    public void startAt(BlockPos pos) {
        this.x.start(pos.func_177958_n());
        this.y.start(0.0f);
        this.z.start(pos.func_177952_p());
        this.moveTo(pos);
    }

    public void moveTo(BlockPos pos) {
        this.moveTo(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void moveTo(float xIn, float yIn, float zIn) {
        this.x.target(xIn);
        this.y.target(yIn);
        this.z.target(zIn);
    }

    public InterpolatedChasingValue getScaleFB() {
        return this.scaleFrontBack;
    }

    public InterpolatedChasingValue getScaleLR() {
        return this.scaleLeftRight;
    }
}

