/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item;

import com.simibubi.create.content.logistics.item.LecternControllerTileEntity;
import com.simibubi.create.content.logistics.item.LinkedControllerItem;
import com.simibubi.create.content.logistics.item.LinkedControllerPacketBase;
import com.simibubi.create.content.logistics.item.LinkedControllerServerHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LinkedControllerInputPacket
extends LinkedControllerPacketBase {
    private Collection<Integer> activatedButtons;
    private boolean press;

    public LinkedControllerInputPacket(Collection<Integer> activatedButtons, boolean press) {
        this(activatedButtons, press, null);
    }

    public LinkedControllerInputPacket(Collection<Integer> activatedButtons, boolean press, BlockPos lecternPos) {
        super(lecternPos);
        this.activatedButtons = activatedButtons;
        this.press = press;
    }

    public LinkedControllerInputPacket(PacketBuffer buffer) {
        super(buffer);
        this.activatedButtons = new ArrayList<Integer>();
        this.press = buffer.readBoolean();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            this.activatedButtons.add(buffer.func_150792_a());
        }
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeBoolean(this.press);
        buffer.func_150787_b(this.activatedButtons.size());
        this.activatedButtons.forEach(arg_0 -> ((PacketBuffer)buffer).func_150787_b(arg_0));
    }

    @Override
    protected void handleLectern(ServerPlayerEntity player, LecternControllerTileEntity lectern) {
        if (lectern.isUsedBy((PlayerEntity)player)) {
            this.handleItem(player, lectern.getController());
        }
    }

    @Override
    protected void handleItem(ServerPlayerEntity player, ItemStack heldItem) {
        World world = player.func_130014_f_();
        UUID uniqueID = player.func_110124_au();
        BlockPos pos = player.func_233580_cy_();
        if (player.func_175149_v() && this.press) {
            return;
        }
        LinkedControllerServerHandler.receivePressed((IWorld)world, pos, uniqueID, this.activatedButtons.stream().map(i -> LinkedControllerItem.toFrequency(heldItem, i)).collect(Collectors.toList()), this.press);
    }
}

